<!DOCTYPE html>
<html lang="en">
<head>
    <title>Projects developed by Justetc, CMS, Helpdesk, Embedded PHP Java .Net Toronto, Ontario, Canada</title>
    <?php require 'head.php' ?>
    <meta name="description" content="Software,  Web, and mobile Projects done by Justetc (Just et cetera) Technologies"/>
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css"/>
    <link rel="stylesheet" href="/resources/demos/style.css"/>
    <link rel="stylesheet" type="text/css" media="screen" href="css/style.css"/>
    <link rel="stylesheet" type="text/css" media="screen" href="css/slider.css"/>
    <link rel="stylesheet" type="text/css" media="screen" href="css/justetc.css"/>

    <!--script src="https://code.jquery.com/jquery-1.12.4.js"></script-->
    <script src="https://code.jquery.com/ui/1.7.1/jquery-ui.js"></script>
    <script>
        $(function () {
            //$("#accordion").accordion();
            $("#accordion").accordion({ header: "h3", collapsible: true, active: false });
        });
    </script>
</head>

<body>
<!--==============================header=================================-->
<?php require 'header.php' ?>
<!--==============================content================================-->
<section id="content">
    <div class="box-row-2 wrap">
        <div class="box"><a href="#" rel="nofollow" class="box-1"><strong>PHP/Java EE</strong></a></div>
        <div class="box"><a href="#" rel="nofollow" class="box-2"><strong>.Net</strong></a></div>
        <div class="box"><a href="#" rel="nofollow" class="box-3"><strong>Mobile</strong></a></div>
        <div class="box"><a href="#" rel="nofollow" class="box-4"><strong>DBMS</strong></a></div>
    </div>
    <div class="container_24">


        <h3>Projects Implemented By Us</h3>
        <div id="accordion">

            <h3>SAP</h3>
            <div class="collapsed">
                <ul>
                    <li> SAP-Webshop (Hybris): Developed a customized SAP B2C Ecommerce site (SAP, J2EE, O/R Mapping)</li>
                    <li> Demo Reporting and Analysis Project in SAP-Hana. Big-data application</li>
                </ul>
            </div>

            <h3>Java/J2EE/J2ME</h3>
            <div>
                <ul>
                    <li>Developed Native Android Applications </li>
                    <li>Developed Cordova/PhoneGap based Native (Hybrid) Mobile  Applications </li>
                    <li> Developed Blackberry applications that were integrated into Project Management software. </li>
                    <li>Developed tools for product price calculation and import/export tool</li>
                    <li> Developed a customized SAP B2C Ecommerce site with integration of Moneris Payment Processing
                        System (SAP and J2EE)
                    </li>
                    <li> Maintained existing eLearning and certification software for TLG for Tourism Canada and Riverview Hospital</li>
                    <li> Added new features, functionalities, and components to eLearning and certification software
                    </li>
                    <li> Designed and developed Practice Exam software</li>
                    <li> Analyzed, designed, and documented databases</li>
                    <li> Designed and developed a Flooding Time Synchronization Protocol for Sensor Networks</li>
                    <li> Designed and developed an Extensible Sensing Service for Home Automation Applications using
                        Sensor Networks
                    </li>
                    <li> Designed and developed a Distributed Reservation System using Java RMI and IBM-DB2 in Linux
                        environment
                    </li>
                    <li> Supervised Java projects such as Library Management, LC Management, Hospital Operation
                        Management. Provided step by step instructions in system analysis, design (front and backend),
                        development, and testing
                    </li>
                    <li> Conducted courses on C, Java (AWT, Swing, JDBC, Applet), Java Script, Software Development
                        using Visual Basic, MSSQL Server, and Crystal Report
                    </li>
                    <li> Supervised Software Development using Java, Visual Basic, Oracle, MSSQL Server, Crystal
                        Report
                    </li>
                </ul>
            </div>

            <h3>PHP/MySQL</h3>
            <div>
                <ul>
                    <li> Laravel
                        <ul>
                            <li> Implemented AirBNB like Vacation Property Rental</li>
                            <li> Customized PIM: Product Information Management System
                            </li>
                            <li> Developed tools to push products to Amazon, and BigCommerce</li>
                            <li> Content Management System for DareFoods</li>
                        </ul>
                    </li>

                    <li> Zend
                        <ul>
                            <li>Extended 411.ca</li>
                            <li> Social referral product for 411.ca</li>
                            <li> Advertiser Center Product for 411.ca</li>
                            <li> Magento based ecommerce systems</li>
                        </ul>
                    </li>

                    <li> Code Igniter
                        <ul>
                            <li> Customer Service Application for Globalstar</li>
                            <li> Technical Support and Return Merchandise Authorization (RMA) Applications for
                                Globalstar
                            </li>
                            <li> Portal to integrate different tools for Globalstar</li>
                            <li> Conference Scheduling Tool for Globalstar</li>
                        </ul>
                    </li>
                    <li> Portal to integrate different tools for Globalstar</li>
                    <li> Prototype mobile web site for Globalstar</li>
                    <li> Helpdesk Management System for Wellington West Capital Inc.</li>
                    <li> Analyzed requirements, designed and developed a overseas teacher recruiting system</li>
                    <li> Designed and developed a MiraServ based payment processing system and integrated into existing
                        web-site
                    </li>
                    <li> Developed a module to provide single sign on service using OpenID and google support</li>
                    <li> Designed and developed web-based Helpdesk Management Software (Customer orders and tickets
                        management, Company services and resources management, Hardware Diagnostics)
                    </li>
                    <li> Designed and developed web-based Airlines Safety Management System</li>
                    <li> Developed Statistical Reporting Software for Airlines Safety Management Systems</li>
                    <li> Analyzed requirements, designed and developed an Academic Information Management System</li>
                    <li> Designed and developed general purpose, ecommerce, and elearning web-sites at JustEtc
                        Technologies
                    </li>
                    <li> Designed, developed, tested, and customized web-applications (at JustETC) such as
                        <ul>
                            <li> Online Classifieds - http://ads.justetc.net (2004 - 2011)</li>
                            <li> Computer Games web-site - http://games.justetc.org (2011)</li>
                            <li> Online Job Board and Recruiting web-site - http://jobs.justetc.net (2010 - 2011)</li>
                            <li> Website for IT Training with Training Videos - http://computer.justetc.net (2006 -
                                2011)
                            </li>
                            <li> Online Shopping Mall - http://mall.justetc.org (2010 - 2011)</li>
                            <li> Internet Marketing - http://addserver.justetc.org and http://traffic.justetc.org (2010
                                - 2011)
                            </li>
                        </ul>
                    </li>
                </ul>
            </div>


            <h3>PHP/MSSQL Server/MySQL</h3>
            <div>
                <ul>
                    <li> Web-application to facilitate Portage (and similar) Investment Program for Wellington West
                        Capital Inc.
                    </li>
                    <li> Fee-billing Web-Application for Wellington West Capital Inc.</li>
                </ul>
            </div>

            <h3>DBMS</h3>
            <div>
                <ul>
                    <li> Enhanced Resolution Database Software in Microsoft Access for NDP and MFL</li>
                    <li> Analyzed an Access Database for a Marketing Company, and cleaned up unwanted items.</li>
                    <li> Modified an existing database to support an Online Course Registration System</li>
                    <li> Analyzed and Modified an existing database to support an Online Appointment Calendar System</li>
                    <li> Designed and implemented the database for an overseas teacher recruiting system</li>
                    <li> Worked with SAP B2C ecommerce application database. Wrote code in Java/J2EE to interact with
                        the SAP B2C ecommerce application database.
                    </li>
                    <li> Analyzed requirements for Practice Exam software, and designed and implemented the database.
                        Also, created design documents such as E-R diagram using UML, and Visio, A word document with
                        description/listing of tables, table attributes, attribute data types, views, stored procedures,
                        sequences
                    </li>
                    <li> Maintained (backup, restore, clearing, update, ) existing databases on E-Learning and
                        Certification software. Also created design documents for existing databases such as Riverview Health Centre
                        Traning Module Database
                    </li>
                    <li> Analyzed requirements and designed and implemented databases for a helpdesk (ticket, resources,
                        order, inventory) management system
                    </li>
                    <li> Created design documents in UML and Visio for the helpdesk system</li>
                    <li> Integrated/merged multiple MySQL databases (Helpdesk, Email, Resources) into one.</li>
                    <li> Imported data from DB-2 database to MySQL database. Wrote scripts for automating transfer of
                        data from DB-2 to MySQL
                    </li>
                    <li> Researched inconsistencies across multiple databases and wrote scripts to find and fix the
                        inconsistencies (MySQL, DB-2)
                    </li>
                    <li> Adapted (added/modified tables, columns, users) a project management database (dotproject in
                        MySQL) to support safety mangement systems
                    </li>
                    <li> Administered Interbase and Firebird database</li>
                    <li> Analyzed requirements, designed and implemented the database for a distributed reservation
                        system in IBM DB-2
                    </li>
                    <li> Analyzed requirements, designed and implemented the database for a university grading system in
                        MSSQL Server
                    </li>
                    <li> Analyzed requirements, designed and implemented the database for a computer aided test taking
                        system in MSSQL Server
                    </li>
                    <li> Database for web-applications to facilitate Portage (and similar) Investment Program for
                        Wellington West Capital Inc.
                    </li>
                    <li> Supervised Software Development using Oracle, MSSQL Server in the back end (Hospital Operation
                        Management, Library Management)
                    </li>
                </ul>
            </div>


            <h3>Reporting Systems</h3>
            <div>
                <ul>
                    <li> Analyzed requirements, designed and developed a reporting component for a overseas teacher
                        recruiting system
                    </li>
                    <li> Analyzed requirements, designed and developed a reporting component for Practice Exam Software
                        in Struts, JSP, Servlet, XML, XPATH, XQuery, PostGreSQL
                    </li>
                    <li> Added new reports to existing reporting software for E-Learning and Certification Software in
                        Struts, JSP, Servlet, XML, XPATH, XQuery, PostGreSQL
                    </li>
                    <li> Developed a reporting software based on the safety management database (MySQL)</li>
                    <li> Developed a statistical reporting software based on reservation software databases. Used
                        replication. (Interbase)
                    </li>
                    <li> Designed and developed reporting software for computer aided test taking system, university
                        grading system in Crystal Reports, MSSQL Server
                    </li>
                </ul>
            </div>


            <h3>Web-hosting</h3>
            <div>
                <ul>
                    <li> Administered commercial hosting services such as Yahoo Hosting, Hostgator Hosting, Vodahost,
                        iPower Hosting, and Mosso
                    </li>
                    <li> Administered hosting in IIS (ASP, .Net, Delphi applications), Apache, Apache Tomcat</li>
                    <li> Hosting Administration with cpanel in commercial hosting solutions</li>
                </ul>
            </div>

            <h3>SEO/SEM</h3>
            <div>
                <ul>
                    <li> Provided SEO and SEM services for Canadian Virtual Hospice</li>
                    <li> Used different strategies of SEM and Internet Marketing for JustETC Technologies</li>
                </ul>
            </div>

            <h3>Content Management Systems</h3>
            <div>
                <ul>
                    <li> Implemented web-sites using Drupal</li>
                    <li> Implemented web-sites using Joomla</li>
                    <li> Configured a community web-site using web-crossing</li>
                </ul>
            </div>


            <h3>Visual Studio/.Net/ASP</h3>
            <div>
                <ul>
                    <li> Developed modules for Project Management Software in .Net</li>
                    <li> Developed a Personal Bank Transaction Management System in .Net</li>
                    <li> Developed an Online Course Registration System in ASP</li>
                    <li> Modified code in ASP.Net for a Calendar module embedded in an ASP.Net web-application</li>
                    <li> Integrated Paypal Payment Processing Code in several ASP based web-sites (used Macromedia
                        Dreamweaver)
                    </li>
                    <li> Converted a Miraserv Payment Processing Module from ASP to PHP (Object Oriented)</li>
                    <li> Provided programming help for a Research Project in Human Computer Interaction in C# and
                        Microsoft
                        Access
                    </li>
                    <li> Designed and developed an ASP.net based personal bank transaction management system</li>
                    <li> Implemented small projects using different concepts in .Net</li>
                    <li> Implemented a business web-site in ASP.net</li>
                    <li> Designed and implemented a Customer Ticket Management System in ASP.Net</li>
                    <li> Analyzed, designed and developed a University Grading System using Visual Basic, Microsoft SQL
                        Server, and VB Report
                    </li>
                    <li> Analyzed, designed, and developed Hospital Operation Management Software using Visual Basic, MS
                        SQL Server, and Crystal Report
                    </li>
                    <li> Designed and developed Computer Aided Test Taking Software using Visual Basic, MSSQL Server and
                        Crystal Report
                    </li>
                    <li> Conducted Software Development courses on Java/J2EE, Visual Basic, Oracle, MSSQL Server, and
                        Crystal Report
                    </li>
                    <li> Closely supervised and provided step by step instructions in developing software projects such
                        as Library Management, Hospital Operation Management, LC Management in Visual Basic, Java, Oracle,
                        and MS SQL Server
                    </li>
                    <li> Supervised a project in Classic ASP and MS SQL Server</li>
                </ul>
            </div>


            <h3>C/C++</h3>
            <div>
                <ul>
                    <li> Implemented a drawing software Similar to the Paint Brush in C</li>
                    <li> Implemented a computer game similar to the Paranoid in C</li>
                    <li> Implemented a simulation software that simulates an OffShore Structure in Visual C++ (MFC)</li>
                    <li> Implemented a simulation software that simulates a Wireless ATM network</li>
                    <li> Implemented a File-based Library Management System in C</li>
                    <li> Implemented a prototype web-server in C</li>
                    <li> Implemented a prototype email client in C</li>
                    <li> Designed and implemented a lift/elevator controller circuit and wrote the software in C</li>
                    <li> Implemented course projects such as Data Structure, Algorithms, Operating Systems, and
                        Networking projects in C/C++
                    </li>
                    <li> Conducted project development course in C</li>
                </ul>
            </div>


            <h3>Microsoft Access/VBA</h3>
            <div>
                <ul>
                    <li> Resolution Database Systems (for NDP, and MFL Canada)</li>
                    <li> Online Training Registration System (for Manitoba Construction Conference)</li>
                    <li> Databases for Binner Marketing, and Sales, and a personal trainer web-site</li>
                    <li> A Research Project in Human Computer Interaction in C# and Microsoft Access</li>
                </ul>
            </div>

            <h3>Projects used XML Technologies</h3>
            <div>
                <ul>
                    <li> SAP Ecommerce Web-site</li>
                    <li> Practice Exam Software</li>
                    <li> E-Learning and Certification Software</li>
                    <li> Helpdesk Management Software</li>
                    <li> Integration of the global GDS system with Airlines Reservations Systems</li>
                </ul>
            </div>

        </div>

        <small>Note: Projects were done either for justetc clients or as part of different positions (contract, full time, part-time, and project based)
        </small>
    </div>
</section>
<!--==============================footer=================================-->
<?php require 'footer.php' ?>
</body>
</html>