<!DOCTYPE html>
<html lang="en">
<head>
    <title>Partner with Justetc</title>
    <?php require 'head.php' ?>
    <meta name="description"
          content="Software,  Web, and mobile Projects done by Justetc (Just et cetera) Technologies"/>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
    <link rel="stylesheet" href="/resources/demos/style.css">
    <link rel="stylesheet" type="text/css" media="screen" href="css/style.css">
    <link rel="stylesheet" type="text/css" media="screen" href="css/slider.css">
    <link rel="stylesheet" type="text/css" media="screen" href="css/justetc.css">

    <!--script src="https://code.jquery.com/jquery-1.12.4.js"></script-->
    <script src="https://code.jquery.com/ui/1.7.1/jquery-ui.js"></script>
    <script>
        $(function () {
            $("#accordion").accordion();
        });
    </script>


</head>
<body>
<!--==============================header=================================-->
<?php require 'header.php' ?>
<!--==============================content================================-->
<section id="content">
    <div class="box-row-2 wrap">
        <div class="box">
            <a href="#" rel="nofollow" class="box-1"><strong>PHP/Java EE</strong></a>
        </div>
        <div class="box">
            <a href="#" rel="nofollow" class="box-2"><strong>.Net</strong></a>
        </div>
        <div class="box">
            <a href="#" rel="nofollow" class="box-3"><strong>Mobile</strong></a>
        </div>
        <div class="box">
            <a href="#" rel="nofollow" class="box-4"><strong>DBMS</strong></a>
        </div>
    </div>
    <div class="container_24">
        <h3>Be Our Partner</h3>
        <div id="accordion">
            <h3>Be a Justetc Partner in Software, Web, Mobile, Database, BI, and Data Analytics Development</h3>
            <div>
                <p>
                    We are looking for genuine partners in Software, Web, Mobile, Database, BI, and Data Analytics Development
                </p>
                <br/>
                <p>We are listing some possible partnership options. However, if you have an idea that might work,
                    please get back to us</p>
            </div>
            <h3>Want to extend your business to Canada and/or USA</h3>
            <div>
                <p>
                    You have got a potential client in Canada. You want us to present you and meet the client on your behalf. We can help with that.                  
                    <br/><br/>
                    You want to present your software products to your existing or potential clients however you are not a Canadian company. We can help with that.                    
                </p>
                
            </div>
            <h3>Develop a Product on Our Behalf</h3>
            <div>
                <p>
                    If you have a qualified team to architect and develop applications, then you might become a partner. We can outsource the product development and/or send our leads on your way.
                </p>
            </div>

        </div>


        <div class="grid_5">
            <dl class="dl1">
                <dt>Justetc Technologies <br/>
                    East York, Toronto, Ontario.
                </dt>
                <dd><span>Telephone:</span></dd>
                <br/>
                <dd>E-mail: <a href="mailto:support@justetc.com" class="color-2">support@justetc.com</a></dd>
            </dl>
        </div>
        <div class="grid_9 prefix_1">
            <h2 class="top-6">Contact Form</h2>
            <form id="form" action='ecom_partners' method='POST'>
                <div class="success">
                    <div class="success_txt">Contact form submitted!<br/><strong> We will be in touch soon.</strong>
                    </div>
                </div>
                <fieldset>
                    <label class="name">
                        <input type="text" value="Name">
                        <span class="error error-empty">*This is not a valid name.</span><span
                                class="empty error-empty">*This field is required.</span> </label>
                    <label class="email">
                        <input type="text" value="E-mail">
                        <span class="error error-empty">*This is not a valid email address.</span><span
                                class="empty error-empty">*This field is required.</span> </label>
                    <label class="phone">
                        <input type="tel" value="Phone">
                        <span class="error error-empty">*This is not a valid phone number.</span><span
                                class="empty error-empty">*This field is required.</span> </label>
                    <label class="message">
                        <textarea>Message</textarea>
                        <span class="error">*The message is too short.</span> <span class="empty">*This field is required.</span>
                    </label>
                    <div class="btns"><a data-type="reset" class="button" href="#">clear</a><a data-type="submit"
                                                                                               class="button">send</a>
                    </div>
                </fieldset>
            </form>
        </div>
        <div class="clear"></div>


    </div>
</section>
<!--==============================footer=================================-->
<?php require 'footer.php' ?>
</body>
</html>