/*! For license information please see Control.Geocoder.modern.js.LICENSE.txt */
import*as L from"leaflet";function geocodingParams(e,t){return L.Util.extend(t,e.geocodingQueryParams)}function reverseParams(e,t){return L.Util.extend(t,e.reverseQueryParams)}let lastCallbackId=0;const badChars=/[&<>"'`]/g,possible=/[&<>"'`]/,escape={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;","`":"&#x60;"};function escapeChar(e){return escape[e]}function htmlEscape(e){return null==e?"":e?(e=""+e,possible.test(e)?e.replace(badChars,escapeChar):e):e+""}function jsonp(e,t,o,s,n){const i="_l_geocoder_"+lastCallbackId++;t[n||"callback"]=i,window[i]=L.Util.bind(o,s);const r=document.createElement("script");r.type="text/javascript",r.src=e+getParamString(t),r.id=i,document.getElementsByTagName("head")[0].appendChild(r)}function getJSON(e,t,o){const s=new XMLHttpRequest;s.onreadystatechange=function(){if(4!==s.readyState)return;let e;if(200!==s.status&&304!==s.status)e="";else if("string"==typeof s.response)try{e=JSON.parse(s.response)}catch(t){e=s.response}else e=s.response;o(e)},s.open("GET",e+getParamString(t),!0),s.responseType="json",s.setRequestHeader("Accept","application/json"),s.send(null)}function template(e,t){return e.replace(/\{ *([\w_]+) *\}/g,((e,o)=>{let s=t[o];return void 0===s?s="":"function"==typeof s&&(s=s(t)),htmlEscape(s)}))}function getParamString(e,t,o){const s=[];for(const t in e){const n=encodeURIComponent(o?t.toUpperCase():t),i=e[t];if(Array.isArray(i))for(let e=0;e<i.length;e++)s.push(n+"="+encodeURIComponent(i[e]));else s.push(n+"="+encodeURIComponent(String(i)))}return(t&&-1!==t.indexOf("?")?"&":"?")+s.join("&")}class ArcGis{constructor(e){this.options={serviceUrl:"https://geocode.arcgis.com/arcgis/rest/services/World/GeocodeServer",apiKey:""},L.Util.setOptions(this,e)}geocode(e,t,o){const s=geocodingParams(this.options,{token:this.options.apiKey,SingleLine:e,outFields:"Addr_Type",forStorage:!1,maxLocations:10,f:"json"});getJSON(this.options.serviceUrl+"/findAddressCandidates",s,(e=>{const s=[];if(e.candidates&&e.candidates.length)for(let t=0;t<=e.candidates.length-1;t++){const o=e.candidates[t],n=L.latLng(o.location.y,o.location.x),i=L.latLngBounds(L.latLng(o.extent.ymax,o.extent.xmax),L.latLng(o.extent.ymin,o.extent.xmin));s[t]={name:o.address,bbox:i,center:n}}t.call(o,s)}))}suggest(e,t,o){return this.geocode(e,t,o)}reverse(e,t,o,s){const n=reverseParams(this.options,{location:e.lng+","+e.lat,distance:100,f:"json"});getJSON(this.options.serviceUrl+"/reverseGeocode",n,(e=>{const t=[];if(e&&!e.error){const o=L.latLng(e.location.y,e.location.x),s=L.latLngBounds(o,o);t.push({name:e.address.Match_addr,center:o,bbox:s})}o.call(s,t)}))}}function arcgis(e){return new ArcGis(e)}class Bing{constructor(e){this.options={serviceUrl:"https://dev.virtualearth.net/REST/v1/Locations"},L.Util.setOptions(this,e)}geocode(e,t,o){const s=geocodingParams(this.options,{query:e,key:this.options.apiKey});jsonp(this.options.apiKey,s,(e=>{const s=[];if(e.resourceSets.length>0)for(let t=e.resourceSets[0].resources.length-1;t>=0;t--){const o=e.resourceSets[0].resources[t],n=o.bbox;s[t]={name:o.name,bbox:L.latLngBounds([n[0],n[1]],[n[2],n[3]]),center:L.latLng(o.point.coordinates)}}t.call(o,s)}),this,"jsonp")}reverse(e,t,o,s){const n=reverseParams(this.options,{key:this.options.apiKey});jsonp(this.options.serviceUrl+e.lat+","+e.lng,n,(e=>{const t=[];for(let o=e.resourceSets[0].resources.length-1;o>=0;o--){const s=e.resourceSets[0].resources[o],n=s.bbox;t[o]={name:s.name,bbox:L.latLngBounds([n[0],n[1]],[n[2],n[3]]),center:L.latLng(s.point.coordinates)}}o.call(s,t)}),this,"jsonp")}}function bing(e){return new Bing(e)}class Google{constructor(e){this.options={serviceUrl:"https://maps.googleapis.com/maps/api/geocode/json"},L.Util.setOptions(this,e)}geocode(e,t,o){const s=geocodingParams(this.options,{key:this.options.apiKey,address:e});getJSON(this.options.serviceUrl,s,(e=>{const s=[];if(e.results&&e.results.length)for(let t=0;t<=e.results.length-1;t++){const o=e.results[t],n=L.latLng(o.geometry.location),i=L.latLngBounds(L.latLng(o.geometry.viewport.northeast),L.latLng(o.geometry.viewport.southwest));s[t]={name:o.formatted_address,bbox:i,center:n,properties:o.address_components}}t.call(o,s)}))}reverse(e,t,o,s){const n=reverseParams(this.options,{key:this.options.apiKey,latlng:e.lat+","+e.lng});getJSON(this.options.serviceUrl,n,(e=>{const t=[];if(e.results&&e.results.length)for(let o=0;o<=e.results.length-1;o++){const s=e.results[o],n=L.latLng(s.geometry.location),i=L.latLngBounds(L.latLng(s.geometry.viewport.northeast),L.latLng(s.geometry.viewport.southwest));t[o]={name:s.formatted_address,bbox:i,center:n,properties:s.address_components}}o.call(s,t)}))}}function google(e){return new Google(e)}class HERE{constructor(e){if(this.options={serviceUrl:"https://geocoder.api.here.com/6.2/",app_id:"",app_code:"",apiKey:"",maxResults:5},L.Util.setOptions(this,e),e.apiKey)throw Error("apiKey is not supported, use app_id/app_code instead!")}geocode(e,t,o){const s=geocodingParams(this.options,{searchtext:e,gen:9,app_id:this.options.app_id,app_code:this.options.app_code,jsonattributes:1,maxresults:this.options.maxResults});this.getJSON(this.options.serviceUrl+"geocode.json",s,t,o)}reverse(e,t,o,s){let n=e.lat+","+e.lng;this.options.reverseGeocodeProxRadius&&(n+=","+this.options.reverseGeocodeProxRadius);const i=reverseParams(this.options,{prox:n,mode:"retrieveAddresses",app_id:this.options.app_id,app_code:this.options.app_code,gen:9,jsonattributes:1,maxresults:this.options.maxResults});this.getJSON(this.options.serviceUrl+"reversegeocode.json",i,o,s)}getJSON(e,t,o,s){getJSON(e,t,(e=>{const t=[];if(e.response.view&&e.response.view.length)for(let o=0;o<=e.response.view[0].result.length-1;o++){const s=e.response.view[0].result[o].location,n=L.latLng(s.displayPosition.latitude,s.displayPosition.longitude),i=L.latLngBounds(L.latLng(s.mapView.topLeft.latitude,s.mapView.topLeft.longitude),L.latLng(s.mapView.bottomRight.latitude,s.mapView.bottomRight.longitude));t[o]={name:s.address.label,properties:s.address,bbox:i,center:n}}o.call(s,t)}))}}class HEREv2{constructor(e){this.options={serviceUrl:"https://geocode.search.hereapi.com/v1",apiKey:"",app_id:"",app_code:"",maxResults:10},L.Util.setOptions(this,e)}geocode(e,t,o){const s=geocodingParams(this.options,{q:e,apiKey:this.options.apiKey,limit:this.options.maxResults});if(!s.at&&!s.in)throw Error("at / in parameters not found. Please define coordinates (at=latitude,longitude) or other (in) in your geocodingQueryParams.");this.getJSON(this.options.serviceUrl+"/discover",s,t,o)}reverse(e,t,o,s){const n=reverseParams(this.options,{at:e.lat+","+e.lng,limit:this.options.reverseGeocodeProxRadius,apiKey:this.options.apiKey});this.getJSON(this.options.serviceUrl+"/revgeocode",n,o,s)}getJSON(e,t,o,s){getJSON(e,t,(e=>{const t=[];if(e.items&&e.items.length)for(let o=0;o<=e.items.length-1;o++){const s=e.items[o],n=L.latLng(s.position.lat,s.position.lng);let i;i=s.mapView?L.latLngBounds(L.latLng(s.mapView.south,s.mapView.west),L.latLng(s.mapView.north,s.mapView.east)):L.latLngBounds(L.latLng(s.position.lat,s.position.lng),L.latLng(s.position.lat,s.position.lng)),t[o]={name:s.address.label,properties:s.address,bbox:i,center:n}}o.call(s,t)}))}}function here(e){return e.apiKey?new HEREv2(e):new HERE(e)}function parseLatLng(e){let t;return(t=e.match(/^([NS])\s*(\d{1,3}(?:\.\d*)?)\W*([EW])\s*(\d{1,3}(?:\.\d*)?)$/))?L.latLng((/N/i.test(t[1])?1:-1)*+t[2],(/E/i.test(t[3])?1:-1)*+t[4]):(t=e.match(/^(\d{1,3}(?:\.\d*)?)\s*([NS])\W*(\d{1,3}(?:\.\d*)?)\s*([EW])$/))?L.latLng((/N/i.test(t[2])?1:-1)*+t[1],(/E/i.test(t[4])?1:-1)*+t[3]):(t=e.match(/^([NS])\s*(\d{1,3})°?\s*(\d{1,3}(?:\.\d*)?)?['′]?\W*([EW])\s*(\d{1,3})°?\s*(\d{1,3}(?:\.\d*)?)?['′]?$/))?L.latLng((/N/i.test(t[1])?1:-1)*(+t[2]+ +t[3]/60),(/E/i.test(t[4])?1:-1)*(+t[5]+ +t[6]/60)):(t=e.match(/^(\d{1,3})°?\s*(\d{1,3}(?:\.\d*)?)?['′]?\s*([NS])\W*(\d{1,3})°?\s*(\d{1,3}(?:\.\d*)?)?['′]?\s*([EW])$/))?L.latLng((/N/i.test(t[3])?1:-1)*(+t[1]+ +t[2]/60),(/E/i.test(t[6])?1:-1)*(+t[4]+ +t[5]/60)):(t=e.match(/^([NS])\s*(\d{1,3})°?\s*(\d{1,2})['′]?\s*(\d{1,3}(?:\.\d*)?)?["″]?\W*([EW])\s*(\d{1,3})°?\s*(\d{1,2})['′]?\s*(\d{1,3}(?:\.\d*)?)?["″]?$/))?L.latLng((/N/i.test(t[1])?1:-1)*(+t[2]+ +t[3]/60+ +t[4]/3600),(/E/i.test(t[5])?1:-1)*(+t[6]+ +t[7]/60+ +t[8]/3600)):(t=e.match(/^(\d{1,3})°?\s*(\d{1,2})['′]?\s*(\d{1,3}(?:\.\d*)?)?["″]\s*([NS])\W*(\d{1,3})°?\s*(\d{1,2})['′]?\s*(\d{1,3}(?:\.\d*)?)?["″]?\s*([EW])$/))?L.latLng((/N/i.test(t[4])?1:-1)*(+t[1]+ +t[2]/60+ +t[3]/3600),(/E/i.test(t[8])?1:-1)*(+t[5]+ +t[6]/60+ +t[7]/3600)):(t=e.match(/^\s*([+-]?\d+(?:\.\d*)?)\s*[\s,]\s*([+-]?\d+(?:\.\d*)?)\s*$/))?L.latLng(+t[1],+t[2]):void 0}class LatLng{constructor(e){this.options={next:void 0,sizeInMeters:1e4},L.Util.setOptions(this,e)}geocode(e,t,o){const s=parseLatLng(e);if(s){const n=[{name:e,center:s,bbox:s.toBounds(this.options.sizeInMeters)}];t.call(o,n)}else this.options.next&&this.options.next.geocode(e,t,o)}}function latLng(e){return new LatLng(e)}class Mapbox{constructor(e){this.options={serviceUrl:"https://api.mapbox.com/geocoding/v5/mapbox.places/"},L.Util.setOptions(this,e)}_getProperties(e){const t={text:e.text,address:e.address};for(let o=0;o<(e.context||[]).length;o++){t[e.context[o].id.split(".")[0]]=e.context[o].text,e.context[o].short_code&&(t.countryShortCode=e.context[o].short_code)}return t}geocode(e,t,o){const s=geocodingParams(this.options,{access_token:this.options.apiKey});void 0!==s.proximity&&void 0!==s.proximity.lat&&void 0!==s.proximity.lng&&(s.proximity=s.proximity.lng+","+s.proximity.lat),getJSON(this.options.serviceUrl+encodeURIComponent(e)+".json",s,(e=>{const s=[];if(e.features&&e.features.length)for(let t=0;t<=e.features.length-1;t++){const o=e.features[t],n=L.latLng(o.center.reverse());let i;i=o.bbox?L.latLngBounds(L.latLng(o.bbox.slice(0,2).reverse()),L.latLng(o.bbox.slice(2,4).reverse())):L.latLngBounds(n,n),s[t]={name:o.place_name,bbox:i,center:n,properties:this._getProperties(o)}}t.call(o,s)}))}suggest(e,t,o){return this.geocode(e,t,o)}reverse(e,t,o,s){getJSON(this.options.serviceUrl+e.lng+","+e.lat+".json",reverseParams(this.options,{access_token:this.options.apiKey}),(e=>{const t=[];if(e.features&&e.features.length)for(let o=0;o<=e.features.length-1;o++){const s=e.features[o],n=L.latLng(s.center.reverse());let i;i=s.bbox?L.latLngBounds(L.latLng(s.bbox.slice(0,2).reverse()),L.latLng(s.bbox.slice(2,4).reverse())):L.latLngBounds(n,n),t[o]={name:s.place_name,bbox:i,center:n,properties:this._getProperties(s)}}o.call(s,t)}))}}function mapbox(e){return new Mapbox(e)}class MapQuest{constructor(e){this.options={serviceUrl:"https://www.mapquestapi.com/geocoding/v1"},L.Util.setOptions(this,e),this.options.apiKey=decodeURIComponent(this.options.apiKey)}_formatName(...e){return e.filter((e=>!!e)).join(", ")}geocode(e,t,o){const s=geocodingParams(this.options,{key:this.options.apiKey,location:e,limit:5,outFormat:"json"});getJSON(this.options.serviceUrl+"/address",s,L.Util.bind((function(e){const s=[];if(e.results&&e.results[0].locations)for(let t=e.results[0].locations.length-1;t>=0;t--){const o=e.results[0].locations[t],n=L.latLng(o.latLng);s[t]={name:this._formatName(o.street,o.adminArea4,o.adminArea3,o.adminArea1),bbox:L.latLngBounds(n,n),center:n}}t.call(o,s)}),this))}reverse(e,t,o,s){const n=reverseParams(this.options,{key:this.options.apiKey,location:e.lat+","+e.lng,outputFormat:"json"});getJSON(this.options.serviceUrl+"/reverse",n,L.Util.bind((function(e){const t=[];if(e.results&&e.results[0].locations)for(let o=e.results[0].locations.length-1;o>=0;o--){const s=e.results[0].locations[o],n=L.latLng(s.latLng);t[o]={name:this._formatName(s.street,s.adminArea4,s.adminArea3,s.adminArea1),bbox:L.latLngBounds(n,n),center:n}}o.call(s,t)}),this))}}function mapQuest(e){return new MapQuest(e)}class Neutrino{constructor(e){this.options={userId:void 0,apiKey:void 0,serviceUrl:"https://neutrinoapi.com/"},L.Util.setOptions(this,e)}geocode(e,t,o){const s=geocodingParams(this.options,{apiKey:this.options.apiKey,userId:this.options.userId,address:e.split(/\s+/).join(".")});getJSON(this.options.serviceUrl+"geocode-address",s,(e=>{const s=[];if(e.locations){e.geometry=e.locations[0];const t=L.latLng(e.geometry.latitude,e.geometry.longitude),o=L.latLngBounds(t,t);s[0]={name:e.geometry.address,bbox:o,center:t}}t.call(o,s)}))}suggest(e,t,o){return this.geocode(e,t,o)}reverse(e,t,o,s){const n=reverseParams(this.options,{apiKey:this.options.apiKey,userId:this.options.userId,latitude:e.lat,longitude:e.lng});getJSON(this.options.serviceUrl+"geocode-reverse",n,(t=>{const n=[];if(200==t.status.status&&t.found){const o=L.latLng(e.lat,e.lng),s=L.latLngBounds(o,o);n[0]={name:t.address,bbox:s,center:o}}o.call(s,n)}))}}function neutrino(e){return new Neutrino(e)}class Nominatim{constructor(e){this.options={serviceUrl:"https://nominatim.openstreetmap.org/",htmlTemplate:function(e){const t=e.address;let o;const s=[];return(t.road||t.building)&&s.push("{building} {road} {house_number}"),(t.city||t.town||t.village||t.hamlet)&&(o=s.length>0?"leaflet-control-geocoder-address-detail":"",s.push('<span class="'+o+'">{postcode} {city} {town} {village} {hamlet}</span>')),(t.state||t.country)&&(o=s.length>0?"leaflet-control-geocoder-address-context":"",s.push('<span class="'+o+'">{state} {country}</span>')),template(s.join("<br/>"),t)}},L.Util.setOptions(this,e||{})}geocode(e,t,o){const s=geocodingParams(this.options,{q:e,limit:5,format:"json",addressdetails:1});getJSON(this.options.serviceUrl+"search",s,(e=>{const s=[];for(let t=e.length-1;t>=0;t--){const o=e[t].boundingbox;for(let e=0;e<4;e++)o[e]=+o[e];s[t]={icon:e[t].icon,name:e[t].display_name,html:this.options.htmlTemplate?this.options.htmlTemplate(e[t]):void 0,bbox:L.latLngBounds([o[0],o[2]],[o[1],o[3]]),center:L.latLng(e[t].lat,e[t].lon),properties:e[t]}}t.call(o,s)}))}reverse(e,t,o,s){const n=reverseParams(this.options,{lat:e.lat,lon:e.lng,zoom:Math.round(Math.log(t/256)/Math.log(2)),addressdetails:1,format:"json"});getJSON(this.options.serviceUrl+"reverse",n,(e=>{const t=[];if(e&&e.lat&&e.lon){const o=L.latLng(e.lat,e.lon),s=L.latLngBounds(o,o);t.push({name:e.display_name,html:this.options.htmlTemplate?this.options.htmlTemplate(e):void 0,center:o,bbox:s,properties:e})}o.call(s,t)}))}}function nominatim(e){return new Nominatim(e)}class OpenLocationCode{constructor(e){L.Util.setOptions(this,e)}geocode(e,t,o){try{const s=this.options.OpenLocationCode.decode(e),n={name:e,center:L.latLng(s.latitudeCenter,s.longitudeCenter),bbox:L.latLngBounds(L.latLng(s.latitudeLo,s.longitudeLo),L.latLng(s.latitudeHi,s.longitudeHi))};t.call(o,[n])}catch(e){t.call(o,[])}}reverse(e,t,o,s){try{const t={name:this.options.OpenLocationCode.encode(e.lat,e.lng,this.options.codeLength),center:L.latLng(e.lat,e.lng),bbox:L.latLngBounds(L.latLng(e.lat,e.lng),L.latLng(e.lat,e.lng))};o.call(s,[t])}catch(e){o.call(s,[])}}}function openLocationCode(e){return new OpenLocationCode(e)}class OpenCage{constructor(e){this.options={serviceUrl:"https://api.opencagedata.com/geocode/v1/json"},L.Util.setOptions(this,e)}geocode(e,t,o){const s=geocodingParams(this.options,{key:this.options.apiKey,q:e});getJSON(this.options.serviceUrl,s,(e=>{const s=[];if(e.results&&e.results.length)for(let t=0;t<e.results.length;t++){const o=e.results[t],n=L.latLng(o.geometry);let i;i=o.annotations&&o.annotations.bounds?L.latLngBounds(L.latLng(o.annotations.bounds.northeast),L.latLng(o.annotations.bounds.southwest)):L.latLngBounds(n,n),s.push({name:o.formatted,bbox:i,center:n})}t.call(o,s)}))}suggest(e,t,o){return this.geocode(e,t,o)}reverse(e,t,o,s){const n=reverseParams(this.options,{key:this.options.apiKey,q:[e.lat,e.lng].join(",")});getJSON(this.options.serviceUrl,n,(e=>{const t=[];if(e.results&&e.results.length)for(let o=0;o<e.results.length;o++){const s=e.results[o],n=L.latLng(s.geometry);let i;i=s.annotations&&s.annotations.bounds?L.latLngBounds(L.latLng(s.annotations.bounds.northeast),L.latLng(s.annotations.bounds.southwest)):L.latLngBounds(n,n),t.push({name:s.formatted,bbox:i,center:n})}o.call(s,t)}))}}function opencage(e){return new OpenCage(e)}class Pelias{constructor(e){this.options={serviceUrl:"https://api.geocode.earth/v1"},this._lastSuggest=0,L.Util.setOptions(this,e)}geocode(e,t,o){const s=geocodingParams(this.options,{api_key:this.options.apiKey,text:e});getJSON(this.options.serviceUrl+"/search",s,(e=>{t.call(o,this._parseResults(e,"bbox"))}))}suggest(e,t,o){const s=geocodingParams(this.options,{api_key:this.options.apiKey,text:e});getJSON(this.options.serviceUrl+"/autocomplete",s,(e=>{e.geocoding.timestamp>this._lastSuggest&&(this._lastSuggest=e.geocoding.timestamp,t.call(o,this._parseResults(e,"bbox")))}))}reverse(e,t,o,s){const n=reverseParams(this.options,{api_key:this.options.apiKey,"point.lat":e.lat,"point.lon":e.lng});getJSON(this.options.serviceUrl+"/reverse",n,(e=>{o.call(s,this._parseResults(e,"bounds"))}))}_parseResults(e,t){const o=[];return L.geoJSON(e,{pointToLayer:function(e,t){return L.circleMarker(t)},onEachFeature:function(e,s){const n={};let i,r;s.getBounds?(i=s.getBounds(),r=i.getCenter()):s.feature.bbox?(r=s.getLatLng(),i=L.latLngBounds(L.GeoJSON.coordsToLatLng(s.feature.bbox.slice(0,2)),L.GeoJSON.coordsToLatLng(s.feature.bbox.slice(2,4)))):(r=s.getLatLng(),i=L.latLngBounds(r,r)),n.name=s.feature.properties.label,n.center=r,n[t]=i,n.properties=s.feature.properties,o.push(n)}}),o}}function pelias(e){return new Pelias(e)}const GeocodeEarth=Pelias,geocodeEarth=pelias,Mapzen=Pelias,mapzen=pelias;class Openrouteservice extends Pelias{constructor(e){super(L.Util.extend({serviceUrl:"https://api.openrouteservice.org/geocode"},e))}}function openrouteservice(e){return new Openrouteservice(e)}class Photon{constructor(e){this.options={serviceUrl:"https://photon.komoot.io/api/",reverseUrl:"https://photon.komoot.io/reverse/",nameProperties:["name","street","suburb","hamlet","town","city","state","country"]},L.Util.setOptions(this,e)}geocode(e,t,o){const s=geocodingParams(this.options,{q:e});getJSON(this.options.serviceUrl,s,L.Util.bind((function(e){t.call(o,this._decodeFeatures(e))}),this))}suggest(e,t,o){return this.geocode(e,t,o)}reverse(e,t,o,s){const n=reverseParams(this.options,{lat:e.lat,lon:e.lng});getJSON(this.options.reverseUrl,n,L.Util.bind((function(e){o.call(s,this._decodeFeatures(e))}),this))}_decodeFeatures(e){const t=[];if(e&&e.features)for(let o=0;o<e.features.length;o++){const s=e.features[o],n=s.geometry.coordinates,i=L.latLng(n[1],n[0]),r=s.properties.extent,a=r?L.latLngBounds([r[1],r[0]],[r[3],r[2]]):L.latLngBounds(i,i);t.push({name:this._decodeFeatureName(s),html:this.options.htmlTemplate?this.options.htmlTemplate(s):void 0,center:i,bbox:a,properties:s.properties})}return t}_decodeFeatureName(e){return(this.options.nameProperties||[]).map((t=>e.properties[t])).filter((e=>!!e)).join(", ")}}function photon(e){return new Photon(e)}class What3Words{constructor(e){this.options={serviceUrl:"https://api.what3words.com/v2/"},L.Util.setOptions(this,e)}geocode(e,t,o){getJSON(this.options.serviceUrl+"forward",geocodingParams(this.options,{key:this.options.apiKey,addr:e.split(/\s+/).join(".")}),(e=>{const s=[];if(e.geometry){const t=L.latLng(e.geometry.lat,e.geometry.lng),o=L.latLngBounds(t,t);s[0]={name:e.words,bbox:o,center:t}}t.call(o,s)}))}suggest(e,t,o){return this.geocode(e,t,o)}reverse(e,t,o,s){getJSON(this.options.serviceUrl+"reverse",reverseParams(this.options,{key:this.options.apiKey,coords:[e.lat,e.lng].join(",")}),(e=>{const t=[];if(200==e.status.status){const o=L.latLng(e.geometry.lat,e.geometry.lng),s=L.latLngBounds(o,o);t[0]={name:e.words,bbox:s,center:o}}o.call(s,t)}))}}function what3words(e){return new What3Words(e)}var geocoders={__proto__:null,geocodingParams:geocodingParams,reverseParams:reverseParams,ArcGis:ArcGis,arcgis:arcgis,Bing:Bing,bing:bing,Google:Google,google:google,HERE:HERE,HEREv2:HEREv2,here:here,parseLatLng:parseLatLng,LatLng:LatLng,latLng:latLng,Mapbox:Mapbox,mapbox:mapbox,MapQuest:MapQuest,mapQuest:mapQuest,Neutrino:Neutrino,neutrino:neutrino,Nominatim:Nominatim,nominatim:nominatim,OpenLocationCode:OpenLocationCode,openLocationCode:openLocationCode,OpenCage:OpenCage,opencage:opencage,Pelias:Pelias,pelias:pelias,GeocodeEarth:GeocodeEarth,geocodeEarth:geocodeEarth,Mapzen:Mapzen,mapzen:mapzen,Openrouteservice:Openrouteservice,openrouteservice:openrouteservice,Photon:Photon,photon:photon,What3Words:What3Words,what3words:what3words};class EventedControl{constructor(...e){}}L.Util.extend(EventedControl.prototype,L.Control.prototype),L.Util.extend(EventedControl.prototype,L.Evented.prototype);class GeocoderControl extends EventedControl{constructor(e){super(e),this.options={showUniqueResult:!0,showResultIcons:!1,collapsed:!0,expand:"touch",position:"topright",placeholder:"Search...",errorMessage:"Nothing found.",iconLabel:"Initiate a new search",query:"",queryMinLength:1,suggestMinLength:3,suggestTimeout:250,defaultMarkGeocode:!0},this._requestCount=0,L.Util.setOptions(this,e),this.options.geocoder||(this.options.geocoder=new Nominatim)}addThrobberClass(){L.DomUtil.addClass(this._container,"leaflet-control-geocoder-throbber")}removeThrobberClass(){L.DomUtil.removeClass(this._container,"leaflet-control-geocoder-throbber")}onAdd(e){const t="leaflet-control-geocoder",o=L.DomUtil.create("div",t+" leaflet-bar"),s=L.DomUtil.create("button",t+"-icon",o),n=this._form=L.DomUtil.create("div",t+"-form",o);this._map=e,this._container=o,s.innerHTML="&nbsp;",s.type="button",s.setAttribute("aria-label",this.options.iconLabel);const i=this._input=L.DomUtil.create("input","",n);return i.type="text",i.value=this.options.query,i.placeholder=this.options.placeholder,L.DomEvent.disableClickPropagation(i),this._errorElement=L.DomUtil.create("div",t+"-form-no-error",o),this._errorElement.innerHTML=this.options.errorMessage,this._alts=L.DomUtil.create("ul",t+"-alternatives leaflet-control-geocoder-alternatives-minimized",o),L.DomEvent.disableClickPropagation(this._alts),L.DomEvent.addListener(i,"keydown",this._keydown,this),this.options.geocoder.suggest&&L.DomEvent.addListener(i,"input",this._change,this),L.DomEvent.addListener(i,"blur",(()=>{this.options.collapsed&&!this._preventBlurCollapse&&this._collapse(),this._preventBlurCollapse=!1})),this.options.collapsed?"click"===this.options.expand?L.DomEvent.addListener(o,"click",(e=>{0===e.button&&2!==e.detail&&this._toggle()})):"touch"===this.options.expand?L.DomEvent.addListener(o,L.Browser.touch?"touchstart mousedown":"mousedown",(e=>{this._toggle(),e.preventDefault(),e.stopPropagation()}),this):(L.DomEvent.addListener(o,"mouseover",this._expand,this),L.DomEvent.addListener(o,"mouseout",this._collapse,this),this._map.on("movestart",this._collapse,this)):(this._expand(),L.Browser.touch?L.DomEvent.addListener(o,"touchstart",(()=>this._geocode())):L.DomEvent.addListener(o,"click",(()=>this._geocode()))),this.options.defaultMarkGeocode&&this.on("markgeocode",this.markGeocode,this),this.on("startgeocode",this.addThrobberClass,this),this.on("finishgeocode",this.removeThrobberClass,this),this.on("startsuggest",this.addThrobberClass,this),this.on("finishsuggest",this.removeThrobberClass,this),L.DomEvent.disableClickPropagation(o),o}setQuery(e){return this._input.value=e,this}_geocodeResult(e,t){if(!t&&this.options.showUniqueResult&&1===e.length)this._geocodeResultSelected(e[0]);else if(e.length>0){this._alts.innerHTML="",this._results=e,L.DomUtil.removeClass(this._alts,"leaflet-control-geocoder-alternatives-minimized"),L.DomUtil.addClass(this._container,"leaflet-control-geocoder-options-open");for(let t=0;t<e.length;t++)this._alts.appendChild(this._createAlt(e[t],t))}else L.DomUtil.addClass(this._container,"leaflet-control-geocoder-options-error"),L.DomUtil.addClass(this._errorElement,"leaflet-control-geocoder-error")}markGeocode(e){const t=e.geocode;return this._map.fitBounds(t.bbox),this._geocodeMarker&&this._map.removeLayer(this._geocodeMarker),this._geocodeMarker=new L.Marker(t.center).bindPopup(t.html||t.name).addTo(this._map).openPopup(),this}_geocode(e){const t=this._input.value;if(!e&&t.length<this.options.queryMinLength)return;const o=++this._requestCount,s=s=>{if(o===this._requestCount){const o={input:t,results:s};this.fire(e?"finishsuggest":"finishgeocode",o),this._geocodeResult(s,e)}};this._lastGeocode=t,e||this._clearResults();const n={input:t};this.fire(e?"startsuggest":"startgeocode",n),e?this.options.geocoder.suggest(t,s):this.options.geocoder.geocode(t,s)}_geocodeResultSelected(e){const t={geocode:e};this.fire("markgeocode",t)}_toggle(){L.DomUtil.hasClass(this._container,"leaflet-control-geocoder-expanded")?this._collapse():this._expand()}_expand(){L.DomUtil.addClass(this._container,"leaflet-control-geocoder-expanded"),this._input.select(),this.fire("expand")}_collapse(){L.DomUtil.removeClass(this._container,"leaflet-control-geocoder-expanded"),L.DomUtil.addClass(this._alts,"leaflet-control-geocoder-alternatives-minimized"),L.DomUtil.removeClass(this._errorElement,"leaflet-control-geocoder-error"),L.DomUtil.removeClass(this._container,"leaflet-control-geocoder-options-open"),L.DomUtil.removeClass(this._container,"leaflet-control-geocoder-options-error"),this._input.blur(),this.fire("collapse")}_clearResults(){L.DomUtil.addClass(this._alts,"leaflet-control-geocoder-alternatives-minimized"),this._selection=null,L.DomUtil.removeClass(this._errorElement,"leaflet-control-geocoder-error"),L.DomUtil.removeClass(this._container,"leaflet-control-geocoder-options-open"),L.DomUtil.removeClass(this._container,"leaflet-control-geocoder-options-error")}_createAlt(e,t){const o=L.DomUtil.create("li",""),s=L.DomUtil.create("a","",o),n=this.options.showResultIcons&&e.icon?L.DomUtil.create("img","",s):null,i=e.html?void 0:document.createTextNode(e.name);return n&&(n.src=e.icon),o.setAttribute("data-result-index",String(t)),e.html?s.innerHTML=s.innerHTML+e.html:i&&s.appendChild(i),L.DomEvent.addListener(o,"mousedown touchstart",(t=>{this._preventBlurCollapse=!0,L.DomEvent.stop(t),this._geocodeResultSelected(e),L.DomEvent.on(o,"click touchend",(()=>{this.options.collapsed?this._collapse():this._clearResults()}))}),this),o}_keydown(e){const t=e=>{this._selection&&(L.DomUtil.removeClass(this._selection,"leaflet-control-geocoder-selected"),this._selection=this._selection[e>0?"nextSibling":"previousSibling"]),this._selection||(this._selection=this._alts[e>0?"firstChild":"lastChild"]),this._selection&&L.DomUtil.addClass(this._selection,"leaflet-control-geocoder-selected")};switch(e.keyCode){case 27:this.options.collapsed?this._collapse():this._clearResults();break;case 38:t(-1);break;case 40:t(1);break;case 13:if(this._selection){const e=parseInt(this._selection.getAttribute("data-result-index"),10);this._geocodeResultSelected(this._results[e]),this._clearResults()}else this._geocode();break;default:return}L.DomEvent.preventDefault(e)}_change(){const e=this._input.value;e!==this._lastGeocode&&(clearTimeout(this._suggestTimeout),e.length>=this.options.suggestMinLength?this._suggestTimeout=setTimeout((()=>this._geocode(!0)),this.options.suggestTimeout):this._clearResults())}}function geocoder(e){return new GeocoderControl(e)}L.Util.extend(GeocoderControl,geocoders),L.Util.extend(L.Control,{Geocoder:GeocoderControl,geocoder:geocoder});export default GeocoderControl;export{GeocoderControl as Geocoder,geocoder,geocoders};