<?php

// this is an include only WP file
if ( !defined( 'ABSPATH' ) ) {
    die;
}
?>
<div class="secnin_content_cell" id="sidebar-container">
	<?php 
global  $secnin_fs ;

if ( !$secnin_fs->is_registered() && !$secnin_fs->is_pending_activation() ) {
    ?>
		<div class="sidebarsection feature">
			<h3><span class="dashicons dashicons-warning"></span> <?php 
    _e( 'Never miss an important update', WF_SN_TEXT_DOMAIN );
    ?></h3>
			<p><?php 
    _e( 'Opt-in to our security and feature updates notifications, and non-sensitive diagnostic tracking.', WF_SN_TEXT_DOMAIN );
    ?></p>
			<?php 
    echo  sprintf( __( '<a href="%s" class="button button-primary button-hero">Click here to opt in.</a>', WF_SN_TEXT_DOMAIN ), secnin_fs()->get_reconnect_url() ) ;
    ?>
		</div>
		<?php 
}

?>
	<div class="sidebarsection feature">
		<h3><span class="dashicons dashicons-welcome-learn-more"></span> <?php 
_e( 'Plugin help', WF_SN_TEXT_DOMAIN );
?></h3>
		<ul class="linklist">
			<?php 
global  $secnin_fs ;

if ( $secnin_fs->is_registered() && !$secnin_fs->is_pending_activation() ) {
    ?>
				<li><a href="#" class="openhelpscout"><?php 
    _e( 'Click to open help beacon', WF_SN_TEXT_DOMAIN );
    ?> <img src="<?php 
    echo  WF_SN_PLUGIN_URL . 'images/helpscout.png' ;
    ?>" height="16" width="16" alt="Help Scout Beacon"></a></li>
				<?php 
}

?>
			<li><a href="<?php 
echo  wf_sn::generate_sn_web_link( 'sidebar_link', '/docs/' ) ;
?>" target="_blank" rel="noopener"><?php 
_e( 'Search Documentation', WF_SN_TEXT_DOMAIN );
?></a></li>

			<li><a href="<?php 
echo  wf_sn::generate_sn_web_link( 'sidebar_link', '/help/' ) ;
?>" target="_blank" rel="noopener"><?php 
_e( 'Need human help? Click here', WF_SN_TEXT_DOMAIN );
?></a></li>

			<li><a href="<?php 
echo  wf_sn::generate_sn_web_link( 'sidebar_link', '/security-tests/' ) ;
?>" target="_blank" rel="noopener"><?php 
_e( 'What security tests are made', WF_SN_TEXT_DOMAIN );
?></a></li>
		</ul>

		<h3><span class="dashicons dashicons-format-aside"></span> <?php 
_e( 'Learn more', WF_SN_TEXT_DOMAIN );
?></h3>
		<ul class="linklist">
			<li><a href="<?php 
echo  wf_sn::generate_sn_web_link( 'sidebar_link', '/why-is-insignificant-small-site-attacked-by-hackers/' ) ;
?>" target="_blank" rel="noopener">Even small sites are attacked by hackers</a></li>

			<li><a href="<?php 
echo  wf_sn::generate_sn_web_link( 'sidebar_link', '/wordpress-beginner-mistakes/' ) ;
?>" target="_blank" rel="noopener">New to WordPress? avoid these beginner mistakes</a></li>

			<li><a href="<?php 
echo  wf_sn::generate_sn_web_link( 'sidebar_link', '/your-guide-to-wordpress-password-and-username-security/' ) ;
?>" target="_blank" rel="noopener">Guide to Password and Username Security</a></li>
			<li><a href="<?php 
echo  wf_sn::generate_sn_web_link( 'sidebar_link', '/signs-wordpress-site-is-hacked/' ) ;
?>" target="_blank" rel="noopener">Signs that your site has been hacked</a></li>

		</ul>

	</div>


</div><!-- #sidebar-container -->