<?php

// this is an include only WP file
if ( !defined( 'ABSPATH' ) ) {
    die;
}
?>
<div class="secnin_content_cell" id="sidebar-container">
	<?php 
global  $secnin_fs ;

if ( !$secnin_fs->is_registered() && !$secnin_fs->is_pending_activation() ) {
    ?>
		<div class="sidebarsection feature">
			<h3><span class="dashicons dashicons-warning"></span> <?php 
    _e( 'Never miss an important update', WF_SN_TEXT_DOMAIN );
    ?></h3>
			<p><?php 
    _e( 'Opt-in to our security and feature updates notifications, and non-sensitive diagnostic tracking.', WF_SN_TEXT_DOMAIN );
    ?></p>
			<?php 
    echo  sprintf( __( '<a href="%s" class="button button-primary button-hero">Click here to opt in.</a>', WF_SN_TEXT_DOMAIN ), secnin_fs()->get_reconnect_url() ) ;
    ?>
		</div>
		<?php 
}


if ( function_exists( 'secnin_fs' ) ) {
    $displayPromotion = true;
    
    if ( $displayPromotion ) {
        ?>
			<div class="snupgradebox sidebarsection feature">
				<h3>Get Security Ninja Pro</h3>
				<ul class="checkmarks">
					<li><strong><?php 
        _e( 'Auto Fixer', WF_SN_TEXT_DOMAIN );
        ?></strong> - <?php 
        _e( 'Fix many security issues with one click.', WF_SN_TEXT_DOMAIN );
        ?></li>
					<li><strong><?php 
        _e( 'Firewall Protection', WF_SN_TEXT_DOMAIN );
        ?></strong> - <?php 
        _e( 'Protect your website.', WF_SN_TEXT_DOMAIN );
        ?></li>
					<li><strong><?php 
        _e( 'Login Protection', WF_SN_TEXT_DOMAIN );
        ?></strong> - <?php 
        _e( 'Stop repeated failed logins.', WF_SN_TEXT_DOMAIN );
        ?></li>
					<li><strong><?php 
        _e( 'Country Blocking', WF_SN_TEXT_DOMAIN );
        ?></strong> - <?php 
        _e( 'Block entire countries.', WF_SN_TEXT_DOMAIN );
        ?></li>
					<li><strong><?php 
        _e( 'Core Scanner', WF_SN_TEXT_DOMAIN );
        ?></strong> - <?php 
        _e( 'Detect infected WordPress core files.', WF_SN_TEXT_DOMAIN );
        ?></li>
					<li><strong><?php 
        _e( 'Plugin Validation', WF_SN_TEXT_DOMAIN );
        ?></strong> - <?php 
        _e( 'Check plugins have not been modified.', WF_SN_TEXT_DOMAIN );
        ?></li>
					<li><strong><?php 
        _e( 'Malware Scanner', WF_SN_TEXT_DOMAIN );
        ?></strong> - <?php 
        _e( 'Find and remove suspicious files.', WF_SN_TEXT_DOMAIN );
        ?></li>
					<li><strong><?php 
        _e( 'Events Logger', WF_SN_TEXT_DOMAIN );
        ?></strong> - <?php 
        _e( 'Audit log - Know who did what on your website', WF_SN_TEXT_DOMAIN );
        ?></li>
					<li><strong><?php 
        _e( 'Support the developers :-)', WF_SN_TEXT_DOMAIN );
        ?></strong></li>
				</ul>
				<p>Try for free for 14 days!</p>
				<a href="<?php 
        echo  secnin_fs()->get_trial_url() ;
        ?>" class="button button-primary trial-button"><?php 
        _e( 'Start free trial', WF_SN_TEXT_DOMAIN );
        ?></a>

				<p><center><em>$7.99 per month. $39/year, or $99 lifetime single payment.</em></center></p>
				<ul class="salenotices">
					<li><?php 
        _e( 'We ask for your payment information to reduce fraud and provide a seamless subscription experience.', WF_SN_TEXT_DOMAIN );
        ?></li>
					<li><?php 
        _e( 'CANCEL ANYTIME before the trial ends to avoid being charged.', WF_SN_TEXT_DOMAIN );
        ?></li>
					<li><?php 
        _e( 'We will send you an email reminder BEFORE your trial ends.', WF_SN_TEXT_DOMAIN );
        ?></li>
					<li><?php 
        _e( 'We accept Visa, Mastercard, American Express and PayPal.', WF_SN_TEXT_DOMAIN );
        ?></li>
					<li><?php 
        _e( 'Upgrade, downgrade or cancel any time.', WF_SN_TEXT_DOMAIN );
        ?></li>
					<li><?php 
        _e( 'Bulk discounts for more websites.', WF_SN_TEXT_DOMAIN );
        ?></li>
				</ul>
				<p><a href="<?php 
        echo  wf_sn::generate_sn_web_link( 'sidebar_link', '/' ) ;
        ?>" target="_blank" rel="noopener"><?php 
        _e( 'Read more about the Pro version', WF_SN_TEXT_DOMAIN );
        ?></a></p>
			</div><!-- .snupgradebox -->
			<?php 
    }

}

?>
	<div class="sidebarsection feature">
		<h3><span class="dashicons dashicons-welcome-learn-more"></span> <?php 
_e( 'Plugin help', WF_SN_TEXT_DOMAIN );
?></h3>
		<ul class="linklist">
			<?php 
global  $secnin_fs ;

if ( $secnin_fs->is_registered() && !$secnin_fs->is_pending_activation() ) {
    ?>
				<li><a href="#" class="openhelpscout"><?php 
    _e( 'Click to open help beacon', WF_SN_TEXT_DOMAIN );
    ?> <img src="<?php 
    echo  WF_SN_PLUGIN_URL . 'images/helpscout.png' ;
    ?>" height="16" width="16" alt="Help Scout Beacon"></a></li>
				<?php 
}

?>
			<li><a href="<?php 
echo  wf_sn::generate_sn_web_link( 'sidebar_link', '/docs/' ) ;
?>" target="_blank" rel="noopener"><?php 
_e( 'Search Documentation', WF_SN_TEXT_DOMAIN );
?></a></li>

			<li><a href="<?php 
echo  wf_sn::generate_sn_web_link( 'sidebar_link', '/help/' ) ;
?>" target="_blank" rel="noopener"><?php 
_e( 'Need human help? Click here', WF_SN_TEXT_DOMAIN );
?></a></li>

			<li><a href="<?php 
echo  wf_sn::generate_sn_web_link( 'sidebar_link', '/security-tests/' ) ;
?>" target="_blank" rel="noopener"><?php 
_e( 'What security tests are made', WF_SN_TEXT_DOMAIN );
?></a></li>
		</ul>

		<h3><span class="dashicons dashicons-format-aside"></span> <?php 
_e( 'Learn more', WF_SN_TEXT_DOMAIN );
?></h3>
		<ul class="linklist">
			<li><a href="<?php 
echo  wf_sn::generate_sn_web_link( 'sidebar_link', '/why-is-insignificant-small-site-attacked-by-hackers/' ) ;
?>" target="_blank" rel="noopener">Even small sites are attacked by hackers</a></li>

			<li><a href="<?php 
echo  wf_sn::generate_sn_web_link( 'sidebar_link', '/wordpress-beginner-mistakes/' ) ;
?>" target="_blank" rel="noopener">New to WordPress? avoid these beginner mistakes</a></li>

			<li><a href="<?php 
echo  wf_sn::generate_sn_web_link( 'sidebar_link', '/your-guide-to-wordpress-password-and-username-security/' ) ;
?>" target="_blank" rel="noopener">Guide to Password and Username Security</a></li>
			<li><a href="<?php 
echo  wf_sn::generate_sn_web_link( 'sidebar_link', '/signs-wordpress-site-is-hacked/' ) ;
?>" target="_blank" rel="noopener">Signs that your site has been hacked</a></li>

		</ul>

	</div>


</div><!-- #sidebar-container -->