<?php

if ( !function_exists( 'add_action' ) ) {
    die( 'Please don\'t open this file directly!' );
}
define( 'WF_SN_VU_OPTIONS_KEY', 'wf_sn_vu_results' );
define( 'WF_SN_VU_VULNS', 'wf_sn_vu_vulns' );
class wf_sn_vu
{
    static  $vu_api_url = 'https://wpsecurityninja.sfo2.cdn.digitaloceanspaces.com/vulnerabilities.json' ;
    // init plugin
    static function init()
    {
        // add tab to Security Ninja tabs
        add_filter( 'sn_tabs', array( __CLASS__, 'sn_tabs' ) );
        // warnings
        add_action( 'admin_notices', array( __CLASS__, 'run_tests_warning' ) );
        // register settings key
        add_action( 'admin_init', array( __CLASS__, 'do_action_admin_init' ) );
    }
    
    // init
    /**
     * Runs on admin_init action
     * @return void
     */
    static function do_action_admin_init()
    {
    }
    
    /**
     * Tab filter
     * @param  [type] $tabs [description]
     * @return [type]       [description]
     */
    static function sn_tabs( $tabs )
    {
        $vuln_tab = array(
            'id'       => 'sn_vuln',
            'class'    => '',
            'label'    => 'Vulnerabilities',
            'callback' => array( __CLASS__, 'vuln_page' ),
        );
        $done = 0;
        for ( $i = 0 ;  $i < sizeof( $tabs ) ;  $i++ ) {
            
            if ( $tabs[$i]['id'] == 'sn_vuln' ) {
                $tabs[$i] = $vuln_tab;
                $done = 1;
                break;
            }
        
        }
        // for
        if ( !$done ) {
            $tabs[] = $vuln_tab;
        }
        return $tabs;
    }
    
    // sn_tabs
    // ref: https://stackoverflow.com/questions/27816105/php-in-array-wildcard-match
    static function stripos_array( $haystack, $needles )
    {
        foreach ( $needles as $needle ) {
            if ( ($res = stripos( $haystack, $needle )) !== false ) {
                return $res;
            }
        }
        return false;
    }
    
    public static function update_vuln_list()
    {
        $wf_sn_vu_vulns = get_option( WF_SN_VU_VULNS );
        // If we have collected before
        
        if ( isset( $wf_sn_vu_vulns->timestamp ) ) {
            $last_update = $wf_sn_vu_vulns->timestamp;
            $current_time = time();
            $seconds_diff = $current_time - $last_update;
            if ( $seconds_diff < DAY_IN_SECONDS ) {
                return true;
            }
        }
        
        global  $secnin_fs ;
        $requestURL = self::$vu_api_url;
        $requestURL = add_query_arg( 'ver', wf_sn::$version, $requestURL );
        $response = wp_remote_get( $requestURL );
        
        if ( !is_wp_error( $response ) ) {
            $body = wp_remote_retrieve_body( $response );
            $sn_vulns_data = json_decode( $body );
            $sn_vulns_data->timestamp = time();
            update_option( WF_SN_VU_VULNS, $sn_vulns_data, 'no' );
        } else {
        }
    
    }
    
    /**
     *  Check if an array is a multidimensional array.
     *
     *  @param   array   $arr  The array to check
     *  @return  boolean       Whether the the array is a multidimensional array or not
     */
    static function is_multi_array( $x )
    {
        if ( count( array_filter( $x, 'is_array' ) ) > 0 ) {
            return true;
        }
        return false;
    }
    
    /**
     *  Convert an object to an array.
     *
     *  @param   array   $object  The object to convert
     *  @return  array            The converted array
     */
    static function object_to_array( $object )
    {
        if ( !is_object( $object ) && !is_array( $object ) ) {
            return $object;
        }
        return array_map( array( __CLASS__, 'object_to_array' ), (array) $object );
    }
    
    /**
     *  Check if a value exists in the array/object.
     *
     *  @param   mixed    $needle    The value that you are searching for
     *  @param   mixed    $haystack  The array/object to search
     *  @param   boolean  $strict    Whether to use strict search or not
     *  @return  boolean             Whether the value was found or not
     */
    static function search_for_value( $needle, $haystack, $strict = true )
    {
        $haystack = self::object_to_array( $haystack );
        if ( is_array( $haystack ) ) {
            
            if ( self::is_multi_array( $haystack ) ) {
                // Multidimensional array
                foreach ( $haystack as $subhaystack ) {
                    if ( self::search_for_value( $needle, $subhaystack, $strict ) ) {
                        return true;
                    }
                }
            } elseif ( array_keys( $haystack ) !== range( 0, count( $haystack ) - 1 ) ) {
                // Associative array
                foreach ( $haystack as $key => $val ) {
                    
                    if ( $needle == $val && !$strict ) {
                        return true;
                    } elseif ( $needle === $val && $strict ) {
                        return true;
                    }
                
                }
                return false;
            } else {
                // Normal array
                
                if ( $needle == $haystack && !$strict ) {
                    return true;
                } elseif ( $needle === $haystack && $strict ) {
                    return true;
                }
            
            }
        
        }
        return false;
    }
    
    // returns vulnerabilities
    static function return_vulnerabilities()
    {
        $vulns = get_option( WF_SN_VU_VULNS );
        
        if ( !$vulns ) {
            self::update_vuln_list();
            $vulns = get_option( WF_SN_VU_VULNS );
        }
        
        $vulnPlugArr = json_decode( json_encode( $vulns->plugins ), true );
        $foundPluginVulns = array();
        $installed_plugins = get_plugins();
        // Tests for plugin problems
        
        if ( $installed_plugins ) {
            wf_sn::timerstart( 'installed_plugins' );
            foreach ( $installed_plugins as $key => $ap ) {
                $lookupID = strtok( $key, '/' );
                $findplugin = array_search( $lookupID, array_column( $vulnPlugArr, 'slug' ) );
                
                if ( $findplugin ) {
                    if ( isset( $vulnPlugArr[$findplugin]['versionEndExcluding'] ) && $vulnPlugArr[$findplugin]['versionEndExcluding'] != '' ) {
                        // check #1 - versionEndExcluding
                        if ( version_compare( $ap['Version'], $vulnPlugArr[$findplugin]['versionEndExcluding'], '<' ) ) {
                            $foundPluginVulns[$lookupID] = array(
                                'name'                => $ap['Name'],
                                'desc'                => $vulnPlugArr[$findplugin]['description'],
                                'installedVersion'    => $ap['Version'],
                                'versionEndExcluding' => $vulnPlugArr[$findplugin]['versionEndExcluding'],
                                'CVE_ID'              => $vulnPlugArr[$findplugin]['CVE_ID'],
                            );
                        }
                    }
                    // Checks via the versionImpact method
                    if ( isset( $vulnPlugArr[$findplugin]['versionImpact'] ) && $vulnPlugArr[$findplugin]['versionImpact'] != '' ) {
                        if ( version_compare( $ap['Version'], $vulnPlugArr[$findplugin]['versionImpact'], '<=' ) ) {
                            $foundPluginVulns[$lookupID] = array(
                                'name'             => $ap['Name'],
                                'desc'             => $vulnPlugArr[$findplugin]['description'],
                                'installedVersion' => $ap['Version'],
                                'versionImpact'    => $vulnPlugArr[$findplugin]['versionImpact'],
                                'CVE_ID'           => $vulnPlugArr[$findplugin]['CVE_ID'],
                            );
                        }
                    }
                }
            
            }
            
            if ( $foundPluginVulns ) {
                return $foundPluginVulns;
            } else {
                return false;
            }
        
        }
        
        // if ($installed_plugins)
    }
    
    static function vuln_page()
    {
        self::update_vuln_list();
        // Get the list of vulnerabilities
        $foundPluginVulns = self::return_vulnerabilities();
        $vulns = get_option( WF_SN_VU_VULNS );
        $pluginVulnsCount = count( $vulns->plugins );
        $WPVulnsCount = count( $vulns->wordpress );
        $vulnsCountTotal = $pluginVulnsCount + $WPVulnsCount;
        $vulnPlugArr = json_decode( json_encode( $vulns->plugins ), true );
        ?>
    	<div class="submit-test-container">
    		<h3>Discover known vulnerabilities in your system</h3>

    		<?php 
        
        if ( $foundPluginVulns ) {
            ?>
    			<h4>Plugin vulnerabilities found on your system!</h4>
    			<p>You should upgrade to latest version or find a different plugin as soon as possible.</p>
    			<?php 
            foreach ( $foundPluginVulns as $key => $fV ) {
                ?>
    				<h3><?php 
                echo  $fV['name'] ;
                ?></h3>
    				<p>Installed version: <?php 
                echo  $fV['installedVersion'] ;
                ?></p>
    				<p><?php 
                echo  $fV['desc'] ;
                ?></br>More details: <a href="https://nvd.nist.gov/vuln/detail/<?php 
                echo  $fV['CVE_ID'] ;
                ?>" target="_blank">Read more about <?php 
                echo  $fV['CVE_ID'] ;
                ?></a></p>

    				<?php 
                
                if ( isset( $fV['versionEndExcluding'] ) ) {
                    ?>
    					<p>Recommendation: Update the plugin to minimum version <?php 
                    echo  $fV['versionEndExcluding'] ;
                    ?></p>
    					<?php 
                }
            
            }
        } else {
            ?>
    			<p>Great, no known vulnerabilities found on your system.</p>
    			<?php 
        }
        
        ?>
    		<?php 
        /*
        <p><a target="_blank" href="<?php echo wf_sn::generate_sn_web_link('tab_vulnerabilities', '/vulnerabilities/'); ?>" class="button button-primary"><?php _e('Learn more', WF_SN_TEXT_DOMAIN); ?></a></p>
        */
        ?>
    		<hr>
    		<p>
    			<?php 
        printf(
            esc_html__( 'Vulnerability list contains %s known  vulnerabilities. Last updated %s (%s)', WF_SN_TEXT_DOMAIN ),
            '<strong>' . number_format_i18n( $vulnsCountTotal ) . '</strong>',
            date_i18n( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ), $vulns->timestamp ),
            human_time_diff( $vulns->timestamp, current_time( 'timestamp' ) ) . ' ' . __( 'ago', WF_SN_TEXT_DOMAIN )
        );
        ?>
    		</p>

    		<?php 
        echo  '</div>' ;
    }
    
    // vuln_page
    // display warning if test were never run
    static function run_tests_warning()
    {
        $tests = get_option( WF_SN_VU_OPTIONS_KEY );
        if ( !wf_sn::is_plugin_page() ) {
            return;
        }
        $foundPluginVulns = self::return_vulnerabilities();
        
        if ( $foundPluginVulns ) {
            $plugVulns = count( $foundPluginVulns );
            ?>
			<div class="notice notice-error"><p>
				<?php 
            printf( _n(
                'You have %s known vulnerability on your website.',
                'You have %s known vulnerabilities on your website.',
                $plugVulns,
                WF_SN_TEXT_DOMAIN
            ), number_format_i18n( $plugVulns ) );
            ?>
			</p>
			<p><?php 
            _e( "Visit the 'Vulnerabilities' tab for more details.", WF_SN_TEXT_DOMAIN );
            ?></p>
		</div>
		<?php 
        }
    
    }
    
    // run_tests_warning
    // clean-up when deactivated
    static function deactivate()
    {
        delete_option( WF_SN_VU_OPTIONS_KEY );
        delete_option( WF_SN_VU_VULNS );
    }

}
// wf_sn_cs class
// @todo - activation routines
// hook everything up
add_action( 'plugins_loaded', array( 'wf_sn_vu', 'init' ) );
// when deativated clean up
register_deactivation_hook( WF_SN_BASE_FILE, array( 'wf_sn_vu', 'deactivate' ) );