<?php


function build_page_object($dic){
	
	$childobject = array();
	$childobject["title"] = $dic->post_title;
	$childobject["link"] = get_permalink($dic->ID);
	$childobject["ml_link"] = plugins_url("get_page.php?page_ID=".$dic->ID,__FILE__);
	$childobject["ml_render"] = ml_page_get_render($dic->ID);
	$childobject["id"] = "$dic->ID";
	
	$comments_count = wp_count_comments($dic->ID);

	$childobject["comments-count"] = 0;
	if($comments_count) {
		$childobject["comments-count"] = intval($comments_count->approved);
	}
		
	//$my_wp_query = new WP_Query();
	//$all_wp_pages = $my_wp_query->query(array('post_type' => 'page'));

	//$children = get_page_children($dic->ID,$all_wp_pages);
	$children = get_pages(array('parent' => $dic->ID));
	
	$childarray = array();
			
	foreach($children as $child){
						
		if($child->post_title!=NULL&&$child->ID!=NULL&&$child->post_parent==$dic->ID){
							
			array_push($childarray,build_page_object($child));
							
		}
						
	}
	
	//wp_reset_postdata();
	
	$childobject["children"] = $childarray;
						
	return $childobject;
	
}

//ini_set('display_errors', 1);

$categories = ml_categories();
$final_categories = array();

$pages = ml_pages();
$final_pages = array();

$final_urls = array();

$final_options = array();

//categories
foreach($categories as $c)
{
	$cat = array();
	if($c->cat_name != NULL && $c->slug != NULL && $c->cat_ID != NULL) {
		$cat["name"] = html_entity_decode($c->cat_name);
		$cat["slug"] = $c->slug;
		$cat["id"] = "$c->cat_ID";
		array_push($final_categories,$cat);
	}
}

$terms = get_option('ml_menu_terms', array());
foreach($terms as $term) {
    $term_data = explode("=", $term);
    $taxonomy = $term_data[0];
    $term_id = $term_data[1];
    $term_object = get_term_by('id', $term_id, $taxonomy);
    if($term_object) {
        $final_categories[] = array(
            'name'=>html_entity_decode($term_object->name),
            'slug'=>$term_object->slug,
            'id'=>$term_object->term_id . ""
        );
    }
}

$tags = get_option('ml_menu_tags', array());
foreach($tags as $tag) {
    $term_object = get_term_by('id', $tag, 'post_tag');
    if($term_object) {
        $final_categories[] = array(
            'name'=>html_entity_decode($term_object->name),
            'slug'=>$term_object->slug,
            'id'=>$term_object->term_id . ""
        );
    }
}

//$my_wp_query = new WP_Query();
//$all_wp_pages = $my_wp_query->query(array('post_type' => 'page'));
//		wp_reset_postdata();
		
		
//pages
foreach($pages as $p)
{
	$page = array();
	if($p->post_title != NULL && $p->ID != NULL) {
		$page["title"] = $p->post_title;
		$page["link"] = get_permalink($p->ID);
		$page["ml_link"] = plugins_url("get_page.php?page_ID=".$p->ID,__FILE__);
		$page["ml_render"] = ml_page_get_render($p->ID);
		$page["id"] = "$p->ID";
		
		$comments_count = wp_count_comments($p->ID);

		$page["comments-count"] = 0;
		if($comments_count) {
			$page["comments-count"] = intval($comments_count->approved);
		}
		
		if(get_option("ml_hierarchical_pages_enabled",true)==true){
				
				
				
				//$children = get_page_children($p->ID,$all_wp_pages);
				
				//
				
				//$children = get_posts(array('posts_per_page'   => -1));
			
			//echo json_encode($children);
				$children = get_pages(array('parent' => $p->ID));
				$childarray = array();
			
				foreach($children as $child){
						
						if($child->post_title!=NULL&&$child->ID!=NULL&&$child->post_parent==$p->ID){
							
							array_push($childarray,build_page_object($child));
							
						}
						
				}
				
				$page["children"] = $childarray;
				
				//wp_reset_postdata();
		}
		
		array_push($final_pages,$page);
	}
}

$urls = get_option("ml_menu_urls",array());
foreach($urls as $url){
	$urlObject = array();
	$urlObject["url"] = $url["url"];
	$urlObject["title"] = $url["urlTitle"];	
	array_push($final_urls,$urlObject);
}

$final_options = array();
$final_options["showFavorites"] = get_option('ml_menu_show_favorites',true);

echo json_encode(array("categories" => $final_categories, "pages" => $final_pages, "urls" => $final_urls, "options" => $final_options));


?>