<?php
class YOP_POLL_Templates_Admin extends YOP_POLL_Abstract_Admin{
    private static $_instance = NULL;

    protected function __construct() {
        parent::__construct( 'templates' );
    }

    public static function get_instance() {
        if ( self::$_instance == NULL ){
            $class           = __CLASS__;
            self::$_instance = new $class;
        }
        return self::$_instance;
    }

    public function manage_templates() {
        switch ( $GLOBALS['page'] ) {
            default:
                $this->manage_options();
                break;
        }

    }

    public function admin_loader() {

        $this->wp_ajax_action( 'yop_poll_add_new_template_config' );
    }

    public function manage_load_templates() {

        wp_enqueue_script( 'yop-poll-admin-templates-js', YOP_POLL_URL . "js/yop-poll-admin-templates.js", array( 'jquery' ), YOP_POLL_VERSION, true );
        wp_enqueue_style( 'yop-poll-timepicker', YOP_POLL_URL . "css/timepicker.css", array(), YOP_POLL_VERSION );
        wp_enqueue_style( 'yop-poll-jquery-ui', YOP_POLL_URL . "css/jquery-ui.css", array(), YOP_POLL_VERSION );

    }
    public function id_used_template($id){
        global $wpdb;
        $results = $wpdb->get_results( $wpdb->prepare( "
					SELECT *
					FROM " . $wpdb->yop_pollmeta  ) );
     foreach($results as $result){
         $meta=unserialize($result->meta_value);
     //    yop_poll_dump($result );
        if($meta['template']==$id||$meta['widget']==$id){
               return false;
        }
     }
     return true;
    }

    private function manage_options() {
        global $page, $action, $message;

        switch ( $action ) {
            case "after-buy":
                YOP_POLL_Pro_Admin::after_buy();
                break;

            case "do-buy":
                YOP_POLL_Pro_Admin::do_buy();
                break;

            case 'add-new-template':
            {
                self:: view_add_edit_templates( 'add-new' );
                break;
            }
            case 'delete':
            {
                $message = $this->delete_templates( $_GET );
                $this->view_templates();
                break;
            }
            case 'clone':
            {
                $message = $this->clone_templates( $_POST );
                $this->view_templates();
                break;
            }
            case 'edit':
            {
                self:: view_add_edit_templates( 'edit' );

                break;
            }
            default: {
            $this->view_templates();
            break;
            }
        }

    }

    public function view_templates() {

        wp_enqueue_script( 'yop-poll-admin-js', YOP_POLL_URL . '/js/polls/yop-poll-admin.js', array(
            'jquery',
            'jquery-ui-datepicker'
        ), YOP_POLL_VERSION, true );
        wp_enqueue_style( 'yop-poll-slider-css', YOP_POLL_URL . 'css/yop-poll-slider.css', array(), YOP_POLL_VERSION );
        wp_enqueue_script( 'yop-poll-slider-js', YOP_POLL_URL . 'js/yop-poll-slider.js', array(
            'jquery',
            'jquery-ui-dialog'
        ), YOP_POLL_VERSION, true );

        global $wpdb, $message;

        global $page, $action, $orderby, $order, $current_user;

        $orderby = ( empty ( $GLOBALS['orderby'] ) ) ? 'name' : $GLOBALS['orderby'];

        $order   = ( empty ( $GLOBALS['order'] ) ) ? 'desc' : $GLOBALS['order'];

        $data['per_page']                            = ( isset ( $_REQUEST ['per_page'] ) ? intval( $_REQUEST ['per_page'] ) : 100 );

        $data['page_no']                             = isset ( $_REQUEST ['page_no'] ) ? ( int )$_REQUEST ['page_no'] : 1;

        $order_fields     = array( 'name', 'last_modified' );

        $data['title']    = __yop_poll( "Templates" );

        $data['REQUEST']  = $_REQUEST;
        $data['poll_url'] =YOP_POLL_URL;
        $data['orderby']                 = ( empty ( $data['REQUEST']['orderby'] ) ) ? 'name' : $data['REQUEST']['orderby'];

        $data['order']                   = ( empty ( $data['REQUEST']['order'] ) ) ? 'desc' : $data['REQUEST']['order'];

        $data['order_direction']         = $this->make_order_array( $order_fields, 'asc', $orderby, ( 'desc' == $order ) ? 'asc' : 'desc' );

        $data['order_sortable']          = $this->make_order_array( $order_fields, 'sortable', $orderby, 'sorted' );

        $data['order_direction_reverse'] = $this->make_order_array( $order_fields, 'desc', $orderby, ( 'desc' == $order ) ? 'desc' : 'asc' );

        $data['search']                  = array( 'fields' => array( 'name', 'last_modified' ), 'value' => isset ( $_REQUEST['s'] ) ? $_REQUEST ['s'] : '' );

        $data['yop_poll_templates']      = Yop_Poll_Model::get_yop_poll_templates_search( $data['orderby'], $data['order'], $data['search'], $data['page_no'] - 1, $data['per_page'] );

        $data['total_templates']         = self::count_yop_poll_templates_search( $data['orderby'], $data['order'], $data['search'] );

        $data['message']                 = array( 'error' => $message['error'], 'succes' => $message['success'] );
        $data['templates']   = YOP_POLL_MODEL::get_yop_poll_templates_search( 'id', 'desc' );
        $n                   = count( $data['templates'] );
        for( $i = 0; $i < $n; $i ++ ) {
            $data['templates'][$i]['preview'] = YOP_POLL_Poll_Model::return_template_preview_html( $data['templates'][$i]['id'] );
        }

        if ( intval( $data['page_no'] ) > intval( $data['total_templates'] ) ){

            $data['page_no'] = 1;

        }

        $args = array(

            'base'      => remove_query_arg(

                'page_no',

                $_SERVER ['REQUEST_URI'] ) . '%_%',

            'format'    => '&page_no=%#%',

            'current'   => max( 1, $data['page_no'] ),

            'total'     => ceil( $data['total_templates'] / $data['per_page'] ),

            'prev_next' => true,

            'prev_text' => __( '&laquo;' ),

            'next_text' => __( '&raquo;' )

        );



        $data['pagination']      = paginate_links( $args );

        $_SERVER ['REQUEST_URI'] = remove_query_arg( array( 'action' ), $_SERVER ['REQUEST_URI'] );

        $data['request']['uri']  = $_SERVER["REQUEST_URI"];





        $this->display( 'templates.html', $data );

    }

    private function view_add_edit_templates( $act ) {
        global $action, $current_user;
       add_filter( 'wp_default_editor', 'force_default_editor' );
        $data['title']       = __yop_poll( "Templates" );
        $data['page_name']   = __yop_poll( "Add New Poll Template" );
        $data['action_type'] = $action;
        $data['template_id'] = '';
        if ( 'edit' == $data['action_type'] ){
            $data['template_id'] = ( isset ( $_GET ['id'] ) ? intval( $_GET ['id'] ) : 0 );

        }


        $data['current_template']     = self::get_poll_template_from_database_by_id( $data['template_id'] );
        $data['template_author_name'] = self::get_poll_template_field_from_database_by_id( 1 );
        $this->display( 'templates_add_edit.html', $data );
    }

    public static function count_yop_poll_templates_search( $orderby = 'last_modified', $order = 'desc', $search = array( 'fields' => array(), 'value' => NULL ) ) {
        global $wpdb;
        $sql        = "SELECT COUNT(*) AS templates_no   FROM " . $wpdb->yop_poll_templates;
        $sql_search = '';
        if ( count( $search['fields'] ) > 0 ){
            $sql_search .= ' ( ';
            foreach ( $search['fields'] as $field ) {
                $sql_search .= $wpdb->prepare( ' `' . $field . '` like \'%%%s%%\' OR', $search['value'] );
            }
            $sql_search = trim( $sql_search, 'OR' );
            $sql_search .= ' ) ';
        }
        if ( count( $search['fields'] ) > 0 ){
            $sql .= ' WHERE ' . $sql_search;
        }

        $sql .= ' ORDER BY ' . $orderby . ' ' . $order;
        $result = $wpdb->get_var( $sql );
        return $result;
    }

    private function  delete_templates( $request ) {
        global $message;
        $message['success'] = "";
        $message['error']   = "";

        if ( isset ( $_REQUEST ['templatecheck'] ) ){
            $bulktemplates = ( array )$_REQUEST ['templatecheck'];
            foreach ( $bulktemplates as $template_id ) {
                $template_id = ( int )$template_id;
                $message     = self::delete_template_from_db( $template_id );
            }
            return $message;
        }

        else {

            if( check_admin_referer('yop-poll-templates-add-edit-action', 'yop-poll-templates-add-edit-name') ) {

                if ( isset ( $_REQUEST ['id'] ) ){
                    if(self::id_used_template( $_REQUEST ['id'])){
                            self::delete_template_from_db( $_REQUEST['id'] );

                    }

                    else      $message['error']='This template is used to display a poll';
                }
            }
            else {
                wp_die( __yop_poll('You do not have enough permission to add a template'));
            }
        }
        return $message;
    }

    private function delete_template_from_db( $template_id ) {
        global $wpdb;
        $response['success'] = "";
        $response['error']   = "";
        if( check_admin_referer('yop-poll-templates-add-edit-action', 'yop-poll-templates-add-edit-name') ) {
            if ( current_user_can( 'delete_own_yop_polls_templates' ) ){
                $sql = $wpdb->query( $wpdb->prepare( "
					DELETE FROM  $wpdb->yop_poll_templates
					WHERE id = %d",
                    $template_id ) );
                if ( $sql ){
                    $response['success'] = __yop_poll( 'Template deleted' );

                }

                else {
                    $response['error'] = __yop_poll( 'Could not delete template from database! Please try again!' );
                }
            }
            else {
                $response['error'] = __yop_poll( 'You do not have enough permission to delete a template' );
            }


            return $response;
        }
        else {
            wp_die( __yop_poll('You do not have enough permission to add a template'));
        }

    }

    private function  clone_templates( $request ) {
        global $message;
        $message['success'] = "";
        $message['error']   = "";

        if ( isset ( $_REQUEST ['templatecheck'] ) ){
            $bulktemplates = ( array )$_REQUEST ['templatecheck'];
            foreach ( $bulktemplates as $template_id ) {
                $template_details = self::get_poll_template_from_database_by_id( $template_id );
                $clone_number     = self::count_poll_template_from_database_like_name( $template_details['name'] . ' - clone' );
                if ( $template_details ){
                    $template = array( 'name' => $template_details['name'] . ' - clone' . ( 0 == $clone_number ? '' : $clone_number ), 'before_vote_template' => $template_details['before_vote_template'], 'after_vote_template' => $template_details['after_vote_template'], 'before_start_date_template' => $template_details['before_start_date_template'], 'after_end_date_template' => $template_details['after_end_date_template'], 'css' => $template_details['css'], 'js' => $template_details['js'], 'status' => ( 'default' == $template_details['status'] ) ? 'other' : $template_details['status'], 'date_added' => NULL, 'last_modified' => NULL );
                    $message  = self::insert_poll_template_to_database( $template );
                }

            }
            $this->view_templates();
        }
        else {

            if ( isset ( $_REQUEST ['id'] ) ){
                $template_details = self::get_poll_template_from_database_by_id( $_REQUEST ['id'] );
                $clone_number     = self::count_poll_template_from_database_like_name( $template_details['name'] . ' - clone' );
                if ( $template_details ){
                    $template = array( 'name' => $template_details['name'] . ' - clone' . ( 0 == $clone_number ? '' : $clone_number ), 'before_vote_template' => $template_details['before_vote_template'], 'after_vote_template' => $template_details['after_vote_template'], 'before_start_date_template' => $template_details['before_start_date_template'], 'after_end_date_template' => $template_details['after_end_date_template'], 'css' => $template_details['css'], 'js' => $template_details['js'], 'status' => ( 'default' == $template_details['status'] ) ? 'other' : $template_details['status'], 'date_added' => NULL, 'last_modified' => NULL );
                    return self::insert_poll_template_to_database( $template );

                }
            }
            $this->view_templates();
        }
        $this->view_templates();

    }
    private static function get_poll_template_from_database_by_id( $template_id = 0 ) {
        global $wpdb;
        $result = $wpdb->get_row( $wpdb->prepare( "
					SELECT *
					FROM " . $wpdb->yop_poll_templates . "
					WHERE id = %d
					LIMIT 0,1
					", $template_id ), ARRAY_A );
        return $result;
    }

    private static function count_poll_template_from_database_like_name( $template_name ) {
        global $wpdb;
        $result = $wpdb->get_var( $wpdb->prepare( "
					SELECT count(*)
					FROM " . $wpdb->yop_poll_templates . "
					WHERE name like %s
					", $template_name . '%' ) );
        return $result;
    }

    private static function insert_poll_template_to_database( $template ) {
        $response['success'] = "";
        $response['error']   = "";
        global $wpdb;
        global $current_user;
        wp_get_current_user();

        if( check_admin_referer('yop-poll-templates-add-edit-action', 'yop-poll-templates-add-edit-name') ) {
            if ( current_user_can( 'clone_own_yop_polls_templates' ) ){
                $sql = $wpdb->query( $wpdb->prepare( "
					INSERT INTO " . $wpdb->yop_poll_templates . "
					SET
					template_author = %d,
					name = %s,
					before_vote_template = %s,
					after_vote_template = %s,
					before_start_date_template = %s,
					after_end_date_template = %s,
					css = %s,
					js = %s,
					date_added = %s,
					last_modified = %s,
					status = %s
					", $current_user->ID, $template['name'], $template['before_vote_template'], $template['after_vote_template'], $template['before_start_date_template'], $template['after_end_date_template'], $template['css'], $template['js'], current_time( 'mysql' ), current_time( 'mysql' ), $template['status'] ) );
                if ( $sql ){
                    $response['success'] = __yop_poll( 'Template cloned!' );
                }
                else {
                    $response['error'] = __yop_poll( 'Could not clone template from database! Please try again!' );
                }
            }
            else {
                $response['error'] = __yop_poll( 'You do not have enough permission to clone a template' );
            }

            return $response;
        }
        else {
            wp_die( __yop_poll( 'You do not have enough permission to add a template' ) );
        }
    }

    public function do_add_edit_template() {
        if ( 'add-new' == $_POST['action'] ){
            if ( ( !current_user_can( 'edit_yop_polls_templates' ) ) && ( !current_user_can( 'edit_yop_polls' ) ) ){
                wp_die( __yop_poll( 'You are not allowed to edit this item.' ) );
            }
        }
        self::save_template();
    }

    public function do_reset_template() {
        if ( ( !current_user_can( 'edit_yop_polls_templates' ) ) && ( !current_user_can( 'edit_yop_polls' ) ) ){
            wp_die( __yop_poll( 'You are not allowed to reset this item.' ) );
        }


        self::reset_template();

    }

    private static function reset_template() {
        $template['name']                       = $_POST['yop_poll_template_name'];
        $template['before_vote_template']       = $_POST['yop-poll-before-vote-template-input'];
        $template['after_vote_template']        = $_POST['yop-poll-after-vote-template-input'];
        $template['before_start_date_template'] = $_POST['yop-poll-template-before-start-date-input'];
        $template['after_end_date_template']    = $_POST['yop-poll-template-after-end-date-input'];
        $template['css']                        = $_POST['yop-poll-template-css-input'];
        $template['js']                         = $_POST['yop-poll-template-js-input'];
        $template['status']                     = "other";
        $template['id']                         = $_POST['template_id'];
        $data['action']                         = $_POST['action'];
        $data['name']                           = $_POST['yop_poll_reset_template_id'];
        $result                                 = self::add_update_templates_in_database( $data['action'], $data['name'], $template['name'] );
        if ( $result ){
            wp_die( __yop_poll( 'Template reseted!' ) );
        }
        else {
            wp_die( __yop_poll( 'Could not resete template in database! Please try again!' ) );
        }
    }

    private static function save_template() {
        $template['name']                       = $_POST['yop_poll_template_name'];
        $template['before_vote_template']       = $_POST['yop-poll-before-vote-template-input'];
        $template['after_vote_template']        = $_POST['yop-poll-after-vote-template-input'];
        $template['before_start_date_template'] = $_POST['yop-poll-template-before-start-date-input'];
        $template['after_end_date_template']    = $_POST['yop-poll-template-after-end-date-input'];
        $template['css']                        = $_POST['yop-poll-template-css-input'];
        $template['js']                         = $_POST['yop-poll-template-js-input'];
        $template['status']                     = "other";
        $template['id']                         = $_POST['template_id'];

        if ( $_POST['action_type'] == "add-new-template" ){
            if ( $template['name'] != "" ){

                $result = self::get_poll_template_from_database_by_name( $template['name'] );
                if ( $result ){
                    wp_die( __yop_poll( 'This template already exists! Please choose another name!' ) );
                }
            }
            else {
                wp_die( __yop_poll( 'Please enter a template name!' ) );
            }
            $result = self:: insert_poll_template_to_database( $template );
            if ( $result ){
                wp_die( __yop_poll( 'Template added!' ) );
            }
            else {
                wp_die( __yop_poll( 'Could not add template in database! Please try again!' ) );
            }
        }
        else {
            if ( $_POST['action_type'] == "edit" ){
                if ( $template['name'] == "" ){
                    wp_die( __yop_poll( 'Please enter a template name!' ) );

                }
                else {
                    $result = self:: update_poll_template_in_database( $template );
                    if ( $result ){
                        wp_die( __yop_poll( 'Template edited!' ) );
                    }
                    else {
                        wp_die( __yop_poll( 'Could not edit template in database! Please try again!' ) );
                    }

                }
            }
        }
    }

    private static function get_poll_template_field_from_database_by_id( $template_id ) {
        global $wpdb;
        $result = $wpdb->get_row( $wpdb->prepare( "
					SELECT user_nicename
					FROM   $wpdb->users
					WHERE ID = %d
					LIMIT 0,1
					", $template_id ), ARRAY_A );
        return $result;

    }

    private static function get_poll_template_from_database_by_name( $template_name ) {
        global $wpdb;

        $sql = $wpdb->query( $wpdb->prepare( "
					SELECT * FROM  $wpdb->yop_poll_templates
					WHERE name = %s
					", $template_name ) );
        return $sql;
    }

    private static function update_poll_template_in_database( $template ) {
        global $wpdb;
        $sql = $wpdb->query( $wpdb->prepare( "
					UPDATE " . $wpdb->yop_poll_templates . "
					SET name = %s,
					before_vote_template = %s,
					after_vote_template = %s,
					before_start_date_template = %s,
					after_end_date_template = %s,
					css = %s,
					js = %s,
					last_modified = %s
					WHERE
					id = %d
					", $template['name'], $template['before_vote_template'], $template['after_vote_template'], $template['before_start_date_template'], $template['after_end_date_template'], $template['css'], $template['js'], current_time( 'mysql' ), $template['id'] ) );
        return $sql;
    }

    private static function add_update_templates_in_database( $action = 'add', $template_name, $template_to_reset ) {

        global $wpdb;

        global $current_user;

        wp_get_current_user();





        $sql = "UPDATE `" . $wpdb->yop_poll_templates . "` SET ";





        $before_vote_template = <<<NOWDOC
<div id = "yop-poll-questions-container-%POLL-ID%">
	[QUESTION_CONTAINER]
	<div id = "yop-poll-question-container-%POLL-ID%-%QUESTION-ID%" class = "yop-poll-question-container-%POLL-ID%">
		<div id = "yop-poll-question-%POLL-ID%-%QUESTION-ID%"
             class = "yop-poll-question-%POLL-ID%">%POLL-QUESTION%</div>
		<div id = "yop-poll-answers-%POLL-ID%-%QUESTION-ID%" class = "yop-poll-answers-%POLL-ID%">
			<ul>
				[ANSWER_CONTAINER]
				<li id = "yop-poll-li-answer-%POLL-ID%-%QUESTION-ID%" class = "yop-poll-li-answer-%POLL-ID%">
					%POLL-ANSWER-CHECK-INPUT% %POLL-ANSWER-LABEL%
                    [ANSWER_DESCRIPTION_CONTAINER]
                    <span class = "yop-poll-description-%POLL-ID%">%ANSWER-DESCRIPTION%</span>
                    [/ANSWER_DESCRIPTION_CONTAINER]

                    [ANSWER_RESULT_CONTAINER]
					<span class = "yop-poll-results-text-%POLL-ID%-%QUESTION-ID%">%POLL-ANSWER-RESULT-LABEL%</span>
					%POLL-ANSWER-RESULT-BAR%
                    [/ANSWER_RESULT_CONTAINER]
				</li>
				[/ANSWER_CONTAINER]
				[OTHER_ANSWER_CONTAINER]
				<li id = "yop-poll-li-answer-%POLL-ID%-%QUESTION-ID%" class = "yop-poll-li-answer-%POLL-ID%">
					%POLL-OTHER-ANSWER-CHECK-INPUT%
					%POLL-OTHER-ANSWER-LABEL%
					<span id = "yop-poll-results-text-%POLL-ID%-%QUESTION-ID%"
                          class = "yop-poll-results-text-%POLL-ID%">%POLL-ANSWER-RESULT-LABEL%</span>
					%POLL-OTHER-ANSWER-TEXT-INPUT%
					%POLL-ANSWER-RESULT-BAR%
				</li>
				[/OTHER_ANSWER_CONTAINER]
			</ul>
		</div>
		<div id = "yop-poll-customs-%POLL-ID%-%QUESTION-ID%" class = "yop-poll-customs-%POLL-ID%">
			<ul>
				[CUSTOM_FIELD_CONTAINER]
				<li id = "yop-poll-li-custom-%POLL-ID%-%QUESTION-ID%" class = "yop-poll-li-custom-%POLL-ID%">
					%POLL-CUSTOM-FIELD-LABEL% %POLL-CUSTOM-FIELD-TEXT-INPUT%
				</li>
				[/CUSTOM_FIELD_CONTAINER]
			</ul>
		</div>
	</div>
	<div class = "yop-poll-clear-%POLL-ID%"></div>
	[/QUESTION_CONTAINER]
</div>
[CAPTCHA_CONTAINER]
<div id = "yop-poll-captcha-%POLL-ID%">
	<div class = "yop-poll-captcha-image-div" id = "yop-poll-captcha-image-div-%POLL-ID%">
		%CAPTCHA-IMAGE%
		<div class = "yop-poll-captcha-helpers-div" id = "yop-poll-captcha-helpers-div-%POLL-ID%">
			%RELOAD-CAPTCHA-IMAGE%
		</div>
		<div class = "yop-poll-clear-%POLL-ID%"></div>
	</div>
	%CAPTCHA-LABEL%
	<div class = "yop-poll-captcha-input-div" id = "yop-poll-captcha-input-div-%POLL-ID%">%CAPTCHA-INPUT%</div>
</div>
[/CAPTCHA_CONTAINER]
<div id = "yop-poll-vote-%POLL-ID%" class = "yop-poll-footer">
	<div>%POLL-VOTE-BUTTON%</div>
	<div id = "yop-poll-results-%POLL-ID%">%POLL-VIEW-RESULT-LINK%</div>
	<div>%POLL-TOTAL-ANSWERS-LABEL%</div>   <div>%POLL-TOTAL-VOTES-LABEL%</div>
</div>
NOWDOC;

        $after_vote_template = <<<NOWDOC
<div id = "yop-poll-questions-container-%POLL-ID%" class = "yop-poll-questions-container-%POLL-ID%">
	[QUESTION_CONTAINER]
	<div id = "yop-poll-question-container-%POLL-ID%-%QUESTION-ID%" class = "yop-poll-question-container-%POLL-ID%">
		<div id = "yop-poll-question-%POLL-ID%-%QUESTION-ID%"
             class = "yop-poll-question-%POLL-ID%">%POLL-QUESTION%</div>
		<div id = "yop-poll-answers-%POLL-ID%-%QUESTION-ID%" class = "yop-poll-answers-%POLL-ID%">
			<ul>
				[ANSWER_RESULT_CONTAINER]
				<li id = "yop-poll-li-result-%POLL-ID%-%QUESTION-ID%" class = "yop-poll-li-result-%POLL-ID%">
					<label id = "pds-feedback-label-%POLL-ID%-%QUESTION-ID%" class = "pds-feedback-label-%POLL-ID%">
                        [ANSWER_DESCRIPTION_CONTAINER]
                        <span class = "yop-poll-description-%POLL-ID%">%ANSWER-DESCRIPTION%</span>
                        [/ANSWER_DESCRIPTION_CONTAINER]
						<span id = "pds-answer-text-%POLL-ID%-%QUESTION-ID%" class = "pds-answer-text-%POLL-ID%">
							%POLL-ANSWER-LABEL%
						</span>
						<span id = "pds-feedback-result-%POLL-ID%-%QUESTION-ID%"
                              class = "pds-feedback-result-%POLL-ID%">
							<span id = "pds-feedback-per-%POLL-ID%-%QUESTION-ID%" class = "pds-feedback-per-%POLL-ID%">
								%POLL-ANSWER-RESULT-LABEL%
							</span>
						</span>
					</label>
                    <div>
                        %POLL-ANSWER-RESULT-BAR%
                    </div>
				</li>
				[/ANSWER_RESULT_CONTAINER]
			</ul>
		</div>
	</div>
	<div class = "yop-poll-clear-%POLL-ID%"></div>
	[/QUESTION_CONTAINER]
</div>
<div id = "yop-poll-vote-%POLL-ID%" class = "yop-poll-footer">
	<div>%POLL-TOTAL-ANSWERS-LABEL%</div>
	<div>%POLL-TOTAL-VOTES-LABEL%</div>
	<div id = "yop-poll-back-%POLL-ID%">%POLL-BACK-TO-VOTE-LINK%</div>
	<div id = "yop-poll-archive-%POLL-ID%">%POLL-VIEW-ARCHIVE-LINK%</div>
	%SHARE-BUTTON%
</div>
NOWDOC;
        $after_vote_template = addslashes( $after_vote_template );

        $before_start_date_template = <<<NOWDOC
This poll is about to<br>
 start on %POLL-START-DATE%<br>
and will end on %POLL-END-DATE%<br>
NOWDOC;
        $before_start_date_template = addslashes( $before_start_date_template );

        $after_end_date_template = <<<NOWDOC
This poll is closed!
Poll activity: <br>
Start date %POLL-START-DATE%<br>
End date %POLL-END-DATE%<br>

Poll Results:
<div id="yop-poll-questions-container-%POLL-ID%" class="yop-poll-questions-container-%POLL-ID%">
	[QUESTION_CONTAINER]
	<div id = "yop-poll-question-container-%POLL-ID%-%QUESTION-ID%" class = "yop-poll-question-container-%POLL-ID%">
		<div id = "yop-poll-question-%POLL-ID%-%QUESTION-ID%"
             class = "yop-poll-question-%POLL-ID%">%POLL-QUESTION%</div>
		<div id = "yop-poll-answers-%POLL-ID%-%QUESTION-ID%" class = "yop-poll-answers-%POLL-ID%">
			<ul>
				[ANSWER_RESULT_CONTAINER]
				<li id = "yop-poll-li-result-%POLL-ID%-%QUESTION-ID%" class = "yop-poll-li-result-%POLL-ID%">
					<label id = "pds-feedback-label-%POLL-ID%-%QUESTION-ID%" class = "pds-feedback-label-%POLL-ID%">
                        [ANSWER_DESCRIPTION_CONTAINER]
                        <span class = "yop-poll-description-%POLL-ID%">%ANSWER-DESCRIPTION%</span>
                        [/ANSWER_DESCRIPTION_CONTAINER]
						<span id = "pds-answer-text-%POLL-ID%-%QUESTION-ID%" class = "pds-answer-text-%POLL-ID%">
							%POLL-ANSWER-LABEL%
						</span>
						<span id = "pds-feedback-result-%POLL-ID%-%QUESTION-ID%"
                              class = "pds-feedback-result-%POLL-ID%">
							<span id = "pds-feedback-per-%POLL-ID%-%QUESTION-ID%" class = "pds-feedback-per-%POLL-ID%">
								%POLL-ANSWER-RESULT-LABEL%
							</span>
						</span>
					</label>
                    <div>
                        %POLL-ANSWER-RESULT-BAR%
                    </div>
				</li>
				[/ANSWER_RESULT_CONTAINER]
			</ul>
		</div>
	</div>
	<div class = "yop-poll-clear-%POLL-ID%"></div>
	[/QUESTION_CONTAINER]
</div>
NOWDOC;
        $after_end_date_template = addslashes( $after_end_date_template );

        $js = <<<NOWDOC
function stripBorder_%POLL-ID%(object) {
	object.each(function() {
		if( parseInt(jQuery(this).width() ) > 0) {
			jQuery(this).width(
				parseInt(
					jQuery(this).width() ) -
					parseInt(jQuery(this).css("border-left-width")) -
					parseInt(jQuery(this).css("border-right-width"))
			);
			}
		else {
		jQuery(this).css("border-left-width", "0px");
		jQuery(this).css("border-right-width", "0px");
		}
	});
}
function stripPadding_%POLL-ID%(object) {
	object.each(function() {
		jQuery(this).width(
		parseInt( jQuery(this).width() ) -
		parseInt(jQuery(this).css("padding-left")) -
		parseInt(jQuery(this).css("padding-left"))
		);
	});
}

function strip_results_%POLL-ID%() {
	stripPadding_%POLL-ID%( jQuery("#yop-poll-container-%POLL-ID% .yop_poll_li_result-%POLL-ID%") );
	stripBorder_%POLL-ID%(  jQuery("#yop-poll-container-%POLL-ID% .yop-poll-result-bar-%POLL-ID%") );
}

jQuery(document).ready(function(e) {
   jQuery('.yop-poll-forms').removeClass('yop-poll-forms-display');
	if(typeof window.strip_results_%POLL-ID% == "function")
		strip_results_%POLL-ID%();
	if(typeof window.tabulate_answers_%POLL-ID% == "function")
		tabulate_answers_%POLL-ID%();
	if(typeof window.tabulate_results_%POLL-ID% == "function")
		tabulate_results_%POLL-ID%();



});

function equalWidth_%POLL-ID%(obj, cols, findWidest ) {

    findWidest  = typeof findWidest  !== "undefined" ? findWidest  : false;
    var quest=0;
    if ( findWidest ) {
        obj.each(function() {
            var thisWidth = jQuery(this).width();
            width = parseInt(thisWidth / cols);
            jQuery(this).width(width);
            jQuery(this).css("float", "left");
        });
    }
    else {
        var widest = 0;
        var count  = 0;
        var poz_each_question=0;

        obj.each(function() {

            count++;
            cols[quest][2]=(jQuery('#yop-poll-answers-%POLL-ID%-'+ cols[quest][3] +' li').length);
            var thisWidth = jQuery(this).width();
            if(thisWidth > widest) {
                widest = thisWidth;
            }
            if(count<cols[quest][2])
            { width = parseInt( %POLL-WIDTH% / cols[quest][0]);
             if(cols[quest][0]==1)
                        jQuery(".yop-poll-li-answer-%POLL-ID%-"+cols[quest][3]).css("width","100%");
             else
                         jQuery(".yop-poll-li-answer-%POLL-ID%-"+cols[quest][3]).width(width-20);
             jQuery(".yop-poll-li-answer-%POLL-ID%-"+cols[quest][3]).css("float", "left");
            }
            else
            {
                count=0;


                width = parseInt( %POLL-WIDTH% / cols[quest][0]);
                jQuery(".yop-poll-li-answer-%POLL-ID%-"+cols[quest][3]).width(width-20);
                jQuery(".yop-poll-li-answer-%POLL-ID%-"+cols[quest][3]).css("float", "left");
                quest++;
            }

        });
}
}

function equalWidth2_%POLL-ID%(obj, cols, findWidest ) {
    findWidest  = typeof findWidest  !== "undefined" ? findWidest  : false;
    var quest=0;

    if ( findWidest ) {
        obj.each(function() {
            var thisWidth = jQuery(this).width();
            width = parseInt(thisWidth / cols);
            jQuery(this).width(width);
            jQuery(this).css("float", "left");
        });
    }
    else {
        var widest = 0;
        var count  = 0;
        var poz_each_question=0;

        obj.each(function() {
            count++;
            cols[quest][2]=(jQuery('#yop-poll-answers-%POLL-ID%-'+ cols[quest][3] +' li').length);
            var thisWidth = jQuery(this).width();
            if(thisWidth > widest) {
                widest = thisWidth;
            }
            if(count<cols[quest][2])
            { width = parseInt( %POLL-WIDTH% / cols[quest][1]);
             jQuery(".yop-poll-li-result-%POLL-ID%-"+cols[quest][3]).width(width-20);
             jQuery(".yop-poll-li-result-%POLL-ID%-"+cols[quest][3]).css("float", "left");
            }
            else
            {
                count=0;


                width = parseInt( %POLL-WIDTH% / cols[quest][1]);
                jQuery(".yop-poll-li-result-%POLL-ID%-"+cols[quest][3]).width(width-20);
                jQuery(".yop-poll-li-result-%POLL-ID%-"+cols[quest][3]).css("float", "left");
                quest++;
            }

        });
}
}
function tabulate_answers_%POLL-ID%() {

	equalWidth_%POLL-ID%( jQuery("#yop-poll-container-%POLL-ID% .yop-poll-li-answer-%POLL-ID%"), %ANSWERS-TABULATED-COLS% );
	//equalWidth_%POLL-ID%( jQuery("#yop-poll-container-%POLL-ID% .yop-poll-li-answer-%POLL-ID% .yop-poll-results-bar-%POLL-ID% div "), %ANSWERS-TABULATED-COLS%, true );
}

function tabulate_results_%POLL-ID%() {
	equalWidth2_%POLL-ID%( jQuery("#yop-poll-container-%POLL-ID% .yop-poll-li-result-%POLL-ID%"), %RESULTS-TABULATED-COLS% );
	//equalWidth_%POLL-ID%( jQuery("#yop-poll-container-%POLL-ID% .yop-poll-li-result-%POLL-ID% .yop-poll-results-bar-%POLL-ID% div "), %RESULTS-TABULATED-COLS%, true );
	}

jQuery(document).ready(function(){
	runOnPollStateChange_%POLL-ID%();
});

function runOnPollStateChange_%POLL-ID%() {

};
NOWDOC;
        $js = addslashes( $js );
        $css = "";

        switch( $template_name ) {
            case 'White':
            { //White
                $css = <<<NOWDOC
/*
  Main Container
  ---------------------------------------------------------------------------
*/
#yop-poll-other-answer-%POLL-ID%-other {
    border:1px solid #000000;
    color:#000000;

}
.yop-poll-customfield-%POLL-ID% {
border:1px solid #000000;
    color:#000000;
}
div#yop-poll-container-%POLL-ID% {
  background:#fff;
  box-sizing: border-box;
  color: #555;
  display: inline-block;
  font-size: 14px;
  padding: 10px;
  width: %POLL-WIDTH%;
  zoom: 1;
}
/* A nice little reset */
div.yop-poll-container * {

}

form#yop-poll-form-%POLL-ID% {

}
/*
  Error message
  ..................................
*/
div#yop-poll-container-error-%POLL-ID% {
  font-size:.8em;
  font-style:italic;
  color:red;
  text-transform:lowercase;
  text-align:center;
}
/*
  Success message
  ..................................
*/
div#yop-poll-container-success-%POLL-ID% {
  font-size:.8em;
  font-style:italic;
  color:green;
  text-align:center;
}
/*
  Poll Question
  ---------------------------------------------------------------------------
*/
div#yop-poll-questions-container-%POLL-ID% { margin:.5em; }
div.yop-poll-question-container-%POLL-ID% { margin: 0; }
div.yop-poll-question-%POLL-ID% {
  border: 0 none;
  margin: 0 0 2em;
  padding: .25em;
  text-align: center;
  font-size: 14px;
}
/*
  Poll Options / Answers
  ---------------------------------------------------------------------------
*/
div.yop-poll-answers-%POLL-ID% {}
div.yop-poll-answers-%POLL-ID% ul {
  list-style: none;
  margin: 0;
  padding: 0;

}
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-answer-%POLL-ID%,
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-result-%POLL-ID% {
  list-style: none;
  margin: 0;
  padding: 0;
  font-size: 14px;
  line-height: 2em;

}
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-result-%POLL-ID% {padding-bottom: 1em;}
/*
  Label
  ..................................
*/
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label {
  margin:0px;
  font-style:normal;
  font-weight:normal;
  font-size:14px;
  float:none;
  display:inline-block;
}
/* Actual text label of the answer */
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(2) {

}
/*
  Custom answer / Other
  ..................................
*/
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(3) {
  width: 100%;
  overflow: hidden;
}
div#yop-poll-container-%POLL-ID%  li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(3) input[type="text"] {
  width: 94%;
  overflow: hidden;
}
/*
  Custom checkbox and radio button style
  ---------------------------------------------------------------------------
*/


/*
  Custom fields
  ---------------------------------------------------------------------------
*/
div.yop-poll-customs-%POLL-ID% {
  clear: both;

}
div.yop-poll-customs-%POLL-ID% ul {
  list-style: none;
  margin: 0;
  padding: 0;
  overflow: hidden;
  width: 100%;
}
div.yop-poll-customs-%POLL-ID% ul li.yop-poll-li-custom-%POLL-ID% {
  display: block;
  font-size:14px;
  list-style: none;
}
div.yop-poll-customs-%POLL-ID% ul li.yop-poll-li-custom-%POLL-ID% label {
  display: block;
}
div#yop-poll-container-%POLL-ID% li.yop-poll-li-custom-%POLL-ID% input[type="text"] {
  width: 94%;
}
/*
  Vote Button
  ---------------------------------------------------------------------------
*/
.yop-poll-footer { /*height: 4em;*/ }

.yop-poll-vote-centered-%POLL-ID% { text-align:center; }

#yop-poll-vote-%POLL-ID% div button {

  cursor:pointer;
  display: block;
  font-size:14px;
  margin: 0 auto;
  }


#yop-poll-vote-%POLL-ID% div button.yop_poll_vote_button {}
#yop-poll-vote-%POLL-ID% div button.yop_poll_wordpress_vote_button { margin: 1em auto 0; }
#yop-poll-vote-%POLL-ID% div button.yop_poll_anonymous_vote_button { margin: 1em auto 0; }

/*
  Results
  ---------------------------------------------------------------------------
*/

li.yop-poll-results-%POLL-ID% {
  font-size: 12px;
  font-style: italic;
  font-weight: normal;
  margin-left: 15px;
  color: #38595E;
}
/*
  Style for results that are displayed on columns
  ..................................
*/
li.yop-poll-li-answer-%POLL-ID% {
  float: left;
  display: inline-block;
  width: 100%;
  padding: 1%;
  margin: 1%;
}

#yop-poll-vote-%POLL-ID% div#yop-poll-results-%POLL-ID% {
  float: right;
  width: auto;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-results-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-back-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-archive-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div {
  float:left;
  width:100%;
}
/*
  Result Bar
  ..................................
*/

.yop-poll-results-bar-%POLL-ID% div { background:#555; width:90%;}


/*
  ---------------------------------------------------------------------------
  EXTRAS
  ---------------------------------------------------------------------------
*/
/*
  CAPTCHA
  ..................................
*/
#yop-poll-captcha-input-div-%POLL-ID% { margin-top:5px; }
#yop-poll-captcha-helpers-div-%POLL-ID% {
  width:30px;
  float:left;
  margin-left:5px;
  height:0px;
}
#yop-poll-captcha-helpers-div-%POLL-ID% img { margin-bottom:2px; }
#yop-poll-captcha-image-div-%POLL-ID% { margin-bottom:5px; }
#yop_poll_captcha_image_%POLL-ID% { float:left; }

.yop-poll-clear-%POLL-ID% { clear:both; }

.yop-poll-name-%POLL-ID% { color:#38595E; font-size: 18px; }


.yop-poll-li-answer-%POLL-ID% label  img     { max-width: 98%; }
.yop-poll-li-result-%POLL-ID% label span img { max-width: 98%; }

.content { position :unset !important; }

div.yop-poll-container br,
div#yop-poll-container-%POLL-ID% br { display: none; }

div#yop_poll_vote_options_div-%POLL-ID% div:nth-last-of-type(1) { display: none; }
NOWDOC;
                break;
            }
            case 'Grey':
            { //Grey
                $css = <<<NOWDOC
/*
  Main Container
  ---------------------------------------------------------------------------
*/
#yop-poll-other-answer-%POLL-ID%-other {
    border:1px solid #000000;
    color:#000000;

}
.yop-poll-customfield-%POLL-ID% {
border:1px solid #000000;
    color:#000000;
}
div#yop-poll-container-%POLL-ID% {
  background:#eee;
  box-sizing: border-box;
  color: #fff;
  display: inline-block;
  font-size: 14px;
  color:#000;
  padding: 10px;
  width: %POLL-WIDTH%;
  zoom: 1;
}
/* A nice little reset */
div.yop-poll-container * {

}

form#yop-poll-form-%POLL-ID% {

}
/*
  Error message
  ..................................
*/
div#yop-poll-container-error-%POLL-ID% {
  font-size:.8em;
  font-style:italic;
  color:red;
  text-transform:lowercase;
  text-align:center;
}
/*
  Success message
  ..................................
*/
div#yop-poll-container-success-%POLL-ID% {
  font-size:.8em;
  font-style:italic;
  color:green;
  text-align:center;
}
/*
  Poll Question
  ---------------------------------------------------------------------------
*/
div#yop-poll-questions-container-%POLL-ID% { margin:.5em; }
div.yop-poll-question-container-%POLL-ID% { margin: 0; }
div.yop-poll-question-%POLL-ID% {
  border: 0 none;
  margin: 0 0 2em;
  padding: .25em;
  text-align: center;
  font-size: 14px;
}
/*
  Poll Options / Answers
  ---------------------------------------------------------------------------
*/
div.yop-poll-answers-%POLL-ID% {}
div.yop-poll-answers-%POLL-ID% ul {
  list-style: none;
  margin: 0;
  padding: 0;

}
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-answer-%POLL-ID%,
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-result-%POLL-ID% {
  list-style: none;
  margin: 0;
  padding: 0;
  font-size: 14px;
  line-height: 2em;

}
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-result-%POLL-ID% {padding-bottom: 1em;}
/*
  Label
  ..................................
*/
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label {
  margin:0px;
  font-style:normal;
  font-weight:normal;
  font-size:14px;
  float:none;
  display:inline-block;
}
/* Actual text label of the answer */
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(2) {

}
/*
  Custom answer / Other
  ..................................
*/
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(3) {
  width: 100%;
  overflow: hidden;
}
div#yop-poll-container-%POLL-ID%  li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(3) input[type="text"] {
  width: 94%;
  overflow: hidden;
}
/*
  Custom checkbox and radio button style
  ---------------------------------------------------------------------------
*/


/*
  Custom fields
  ---------------------------------------------------------------------------
*/
div.yop-poll-customs-%POLL-ID% {
  clear: both;

}
div.yop-poll-customs-%POLL-ID% ul {
  list-style: none;
  margin: 0;
  padding: 0;
  overflow: hidden;
  width: 100%;
}
div.yop-poll-customs-%POLL-ID% ul li.yop-poll-li-custom-%POLL-ID% {
  display: block;
  font-size:14px;
  list-style: none;
}
div.yop-poll-customs-%POLL-ID% ul li.yop-poll-li-custom-%POLL-ID% label {
  display: block;
}
div#yop-poll-container-%POLL-ID% li.yop-poll-li-custom-%POLL-ID% input[type="text"] {
  width: 94%;
}
/*
  Vote Button
  ---------------------------------------------------------------------------
*/
.yop-poll-footer { /*height: 4em;*/ }

.yop-poll-vote-centered-%POLL-ID% { text-align:center; }

#yop-poll-vote-%POLL-ID% div button {

  cursor:pointer;
  display: block;
  font-size:14px;
  margin: 0 auto;
  }


#yop-poll-vote-%POLL-ID% div button.yop_poll_vote_button {}
#yop-poll-vote-%POLL-ID% div button.yop_poll_wordpress_vote_button { margin: 1em auto 0; }
#yop-poll-vote-%POLL-ID% div button.yop_poll_anonymous_vote_button { margin: 1em auto 0; }

/*
  Results
  ---------------------------------------------------------------------------
*/

li.yop-poll-results-%POLL-ID% {
  font-size: 12px;
  font-style: italic;
  font-weight: normal;
  margin-left: 15px;
  color: #38595E;
}
/*
  Style for results that are displayed on columns
  ..................................
*/
li.yop-poll-li-answer-%POLL-ID% {
  float: left;
  display: inline-block;
  width: 100%;
  padding: 1%;
  margin: 1%;
}

#yop-poll-vote-%POLL-ID% div#yop-poll-results-%POLL-ID% {
  float: right;
  width: auto;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-results-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-back-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-archive-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div {
  float:left;
  width:100%;
}
/*
  Result Bar
  ..................................
*/

.yop-poll-results-bar-%POLL-ID% div { background:#555; width:90%;}


/*
  ---------------------------------------------------------------------------
  EXTRAS
  ---------------------------------------------------------------------------
*/
/*
  CAPTCHA
  ..................................
*/
#yop-poll-captcha-input-div-%POLL-ID% { margin-top:5px; }
#yop-poll-captcha-helpers-div-%POLL-ID% {
  width:30px;
  float:left;
  margin-left:5px;
  height:0px;
}
#yop-poll-captcha-helpers-div-%POLL-ID% img { margin-bottom:2px; }
#yop-poll-captcha-image-div-%POLL-ID% { margin-bottom:5px; }
#yop_poll_captcha_image_%POLL-ID% { float:left; }

.yop-poll-clear-%POLL-ID% { clear:both; }

.yop-poll-name-%POLL-ID% { color:#38595E; font-size: 18px; }


.yop-poll-li-answer-%POLL-ID% label  img     { max-width: 98%; }
.yop-poll-li-result-%POLL-ID% label span img { max-width: 98%; }

.content { position :unset !important; }

div.yop-poll-container br,
div#yop-poll-container-%POLL-ID% br { display: none; }

div#yop_poll_vote_options_div-%POLL-ID% div:nth-last-of-type(1) { display: none; }







NOWDOC;
                break;
            }
            case 'Dark':
            { //Dark
                $css = <<<NOWDOC
/*
  Main Container
  ---------------------------------------------------------------------------
*/
#yop-poll-other-answer-%POLL-ID%-other {
    color:#000000;

}
.yop-poll-customfield-%POLL-ID% {
    color:#000000;
}
div#yop-poll-container-%POLL-ID% {
  background:#555;
  box-sizing: border-box;
  color: #fff;
  display: inline-block;
  font-size: 14px;
  padding: 10px;
  width: %POLL-WIDTH%;
  zoom: 1;
}
/* A nice little reset */
div.yop-poll-container * {

}

form#yop-poll-form-%POLL-ID% {

}
/*
  Error message
  ..................................
*/
div#yop-poll-container-error-%POLL-ID% {
  font-size:.8em;
  font-style:italic;
  color:red;
  text-transform:lowercase;
  text-align:center;
}
/*
  Success message
  ..................................
*/
div#yop-poll-container-success-%POLL-ID% {
  font-size:.8em;
  font-style:italic;
  color:green;
  text-align:center;
}
/*
  Poll Question
  ---------------------------------------------------------------------------
*/
div#yop-poll-questions-container-%POLL-ID% { margin:.5em; }
div.yop-poll-question-container-%POLL-ID% { margin: 0; }
div.yop-poll-question-%POLL-ID% {
  border: 0 none;
  margin: 0 0 2em;
  padding: .25em;
  text-align: center;
  font-size: 14px;
}
/*
  Poll Options / Answers
  ---------------------------------------------------------------------------
*/
div.yop-poll-answers-%POLL-ID% {}
div.yop-poll-answers-%POLL-ID% ul {
  list-style: none;
  margin: 0;
  padding: 0;

}
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-answer-%POLL-ID%,
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-result-%POLL-ID% {
  list-style: none;
  margin: 0;
  padding: 0;
  font-size: 14px;
  line-height: 2em;

}
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-result-%POLL-ID% {padding-bottom: 1em;}
/*
  Label
  ..................................
*/
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label {
  margin:0px;
  font-style:normal;
  font-weight:normal;
  font-size:14px;
  float:none;
  display:inline-block;
}
/* Actual text label of the answer */
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(2) {

}
/*
  Custom answer / Other
  ..................................
*/
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(3) {
  width: 100%;
  overflow: hidden;
}
div#yop-poll-container-%POLL-ID%  li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(3) input[type="text"] {
  width: 94%;
  overflow: hidden;
}
/*
  Custom checkbox and radio button style
  ---------------------------------------------------------------------------
*/


/*
  Custom fields
  ---------------------------------------------------------------------------
*/
div.yop-poll-customs-%POLL-ID% {
  clear: both;

}
div.yop-poll-customs-%POLL-ID% ul {
  list-style: none;
  margin: 0;
  padding: 0;
  overflow: hidden;
  width: 100%;
}
div.yop-poll-customs-%POLL-ID% ul li.yop-poll-li-custom-%POLL-ID% {
  display: block;
  font-size:14px;
  list-style: none;
}
div.yop-poll-customs-%POLL-ID% ul li.yop-poll-li-custom-%POLL-ID% label {
  display: block;
}
div#yop-poll-container-%POLL-ID% li.yop-poll-li-custom-%POLL-ID% input[type="text"] {
  width: 94%;
}
/*
  Vote Button
  ---------------------------------------------------------------------------
*/
.yop-poll-footer { /*height: 4em;*/ }

.yop-poll-vote-centered-%POLL-ID% { text-align:center; }

#yop-poll-vote-%POLL-ID% div button {

  cursor:pointer;
  display: block;
  font-size:14px;
  margin: 0 auto;
  }


#yop-poll-vote-%POLL-ID% div button.yop_poll_vote_button {}
#yop-poll-vote-%POLL-ID% div button.yop_poll_wordpress_vote_button { margin: 1em auto 0; }
#yop-poll-vote-%POLL-ID% div button.yop_poll_anonymous_vote_button { margin: 1em auto 0; }

/*
  Results
  ---------------------------------------------------------------------------
*/

li.yop-poll-results-%POLL-ID% {
  font-size: 12px;
  font-style: italic;
  font-weight: normal;
  margin-left: 15px;
  color: #38595E;
}
/*
  Style for results that are displayed on columns
  ..................................
*/
li.yop-poll-li-answer-%POLL-ID% {
  float: left;
  display: inline-block;
  width: 100%;
  padding: 1%;
  margin: 1%;
}

#yop-poll-vote-%POLL-ID% div#yop-poll-results-%POLL-ID% {
  float: right;
  width: auto;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-results-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-back-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-archive-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div {
  float:left;
  width:100%;
}
/*
  Result Bar
  ..................................
*/

.yop-poll-results-bar-%POLL-ID% div { background:#555; width:90%;}


/*
  ---------------------------------------------------------------------------
  EXTRAS
  ---------------------------------------------------------------------------
*/
/*
  CAPTCHA
  ..................................
*/
#yop-poll-captcha-input-div-%POLL-ID% { margin-top:5px; }
#yop-poll-captcha-helpers-div-%POLL-ID% {
  width:30px;
  float:left;
  margin-left:5px;
  height:0px;
}
#yop-poll-captcha-helpers-div-%POLL-ID% img { margin-bottom:2px; }
#yop-poll-captcha-image-div-%POLL-ID% { margin-bottom:5px; }
#yop_poll_captcha_image_%POLL-ID% { float:left; }

.yop-poll-clear-%POLL-ID% { clear:both; }

.yop-poll-name-%POLL-ID% { color:#38595E; font-size: 18px; }


.yop-poll-li-answer-%POLL-ID% label  img     { max-width: 98%; }
.yop-poll-li-result-%POLL-ID% label span img { max-width: 98%; }

.content { position :unset !important; }

div.yop-poll-container br,
div#yop-poll-container-%POLL-ID% br { display: none; }

div#yop_poll_vote_options_div-%POLL-ID% div:nth-last-of-type(1) { display: none; }








NOWDOC;
                break;
            }
            case 'Blue v1':
            { //Blue v1
                $css = <<<NOWDOC
/*
  Main Container
  ---------------------------------------------------------------------------
*/
#yop-poll-other-answer-%POLL-ID%-other {
    color:#000000;

}
.yop-poll-customfield-%POLL-ID% {
    color:#000000;
}
div#yop-poll-container-%POLL-ID% {
  background:#327BD6;
  box-sizing: border-box;
  color: #fff;
  display: inline-block;
  font-size: 14px;
  padding: 10px;
  width: %POLL-WIDTH%;
  zoom: 1;
}
/* A nice little reset */
div.yop-poll-container * {

}

form#yop-poll-form-%POLL-ID% {

}
/*
  Error message
  ..................................
*/
div#yop-poll-container-error-%POLL-ID% {
  font-size:.8em;
  font-style:italic;
  color:red;
  text-transform:lowercase;
  text-align:center;
}
/*
  Success message
  ..................................
*/
div#yop-poll-container-success-%POLL-ID% {
  font-size:.8em;
  font-style:italic;
  color:green;
  text-align:center;
}
/*
  Poll Question
  ---------------------------------------------------------------------------
*/
div#yop-poll-questions-container-%POLL-ID% { margin:.5em; }
div.yop-poll-question-container-%POLL-ID% { margin: 0; }
div.yop-poll-question-%POLL-ID% {
  border: 0 none;
  margin: 0 0 2em;
  padding: .25em;
  text-align: center;
  font-size: 14px;
}
/*
  Poll Options / Answers
  ---------------------------------------------------------------------------
*/
div.yop-poll-answers-%POLL-ID% {}
div.yop-poll-answers-%POLL-ID% ul {
  list-style: none;
  margin: 0;
  padding: 0;

}
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-answer-%POLL-ID%,
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-result-%POLL-ID% {
  list-style: none;
  margin: 0;
  padding: 0;
  font-size: 14px;
  line-height: 2em;

}
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-result-%POLL-ID% {padding-bottom: 1em;}
/*
  Label
  ..................................
*/
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label {
  margin:0px;
  font-style:normal;
  font-weight:normal;
  font-size:14px;
  float:none;
  display:inline-block;
}
/* Actual text label of the answer */
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(2) {

}
/*
  Custom answer / Other
  ..................................
*/
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(3) {
  width: 100%;
  overflow: hidden;
}
div#yop-poll-container-%POLL-ID%  li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(3) input[type="text"] {
  width: 94%;
  overflow: hidden;
}
/*
  Custom checkbox and radio button style
  ---------------------------------------------------------------------------
*/


/*
  Custom fields
  ---------------------------------------------------------------------------
*/
div.yop-poll-customs-%POLL-ID% {
  clear: both;

}
div.yop-poll-customs-%POLL-ID% ul {
  list-style: none;
  margin: 0;
  padding: 0;
  overflow: hidden;
  width: 100%;
}
div.yop-poll-customs-%POLL-ID% ul li.yop-poll-li-custom-%POLL-ID% {
  display: block;
  font-size:14px;
  list-style: none;
}
div.yop-poll-customs-%POLL-ID% ul li.yop-poll-li-custom-%POLL-ID% label {
  display: block;
}
div#yop-poll-container-%POLL-ID% li.yop-poll-li-custom-%POLL-ID% input[type="text"] {
  width: 94%;
}
/*
  Vote Button
  ---------------------------------------------------------------------------
*/
.yop-poll-footer { /*height: 4em;*/ }

.yop-poll-vote-centered-%POLL-ID% { text-align:center; }

#yop-poll-vote-%POLL-ID% div button {

  cursor:pointer;
  display: block;
  font-size:14px;
  margin: 0 auto;
  }


#yop-poll-vote-%POLL-ID% div button.yop_poll_vote_button {}
#yop-poll-vote-%POLL-ID% div button.yop_poll_wordpress_vote_button { margin: 1em auto 0; }
#yop-poll-vote-%POLL-ID% div button.yop_poll_anonymous_vote_button { margin: 1em auto 0; }

/*
  Results
  ---------------------------------------------------------------------------
*/

li.yop-poll-results-%POLL-ID% {
  font-size: 12px;
  font-style: italic;
  font-weight: normal;
  margin-left: 15px;
  color: #38595E;
}
/*
  Style for results that are displayed on columns
  ..................................
*/
li.yop-poll-li-answer-%POLL-ID% {
  float: left;
  display: inline-block;
  width: 100%;
  padding: 1%;
  margin: 1%;
}

#yop-poll-vote-%POLL-ID% div#yop-poll-results-%POLL-ID% {
  float: right;
  width: auto;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-results-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-back-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-archive-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div {
  float:left;
  width:100%;
}
/*
  Result Bar
  ..................................
*/

.yop-poll-results-bar-%POLL-ID% div { background:#555; width:90%;}


/*
  ---------------------------------------------------------------------------
  EXTRAS
  ---------------------------------------------------------------------------
*/
/*
  CAPTCHA
  ..................................
*/
#yop-poll-captcha-input-div-%POLL-ID% { margin-top:5px; }
#yop-poll-captcha-helpers-div-%POLL-ID% {
  width:30px;
  float:left;
  margin-left:5px;
  height:0px;
}
#yop-poll-captcha-helpers-div-%POLL-ID% img { margin-bottom:2px; }
#yop-poll-captcha-image-div-%POLL-ID% { margin-bottom:5px; }
#yop_poll_captcha_image_%POLL-ID% { float:left; }

.yop-poll-clear-%POLL-ID% { clear:both; }

.yop-poll-name-%POLL-ID% { color:#38595E; font-size: 18px; }


.yop-poll-li-answer-%POLL-ID% label  img     { max-width: 98%; }
.yop-poll-li-result-%POLL-ID% label span img { max-width: 98%; }

.content { position :unset !important; }

div.yop-poll-container br,
div#yop-poll-container-%POLL-ID% br { display: none; }

div#yop_poll_vote_options_div-%POLL-ID% div:nth-last-of-type(1) { display: none; }
NOWDOC;
                break;
            }
            case 'Blue v2':
            { //Blue v2
                $css = <<<NOWDOC
/*
  Main Container
  ---------------------------------------------------------------------------
*/
#yop-poll-other-answer-%POLL-ID%-other {
    border:1px solid #000000;
    color:#000000;

}
.yop-poll-customfield-%POLL-ID% {
border:1px solid #000000;
    color:#000000;
}
div#yop-poll-container-%POLL-ID% {
  background:#fff;
  box-sizing: border-box;
  display: inline-block;
  font-size: 14px;
  color:#555;
  padding: 10px;
  width: %POLL-WIDTH%;
  zoom: 1;
}
/* A nice little reset */
div.yop-poll-container * {

}

form#yop-poll-form-%POLL-ID% {

}
/*
  Error message
  ..................................
*/
div#yop-poll-container-error-%POLL-ID% {
  font-size:.8em;
  font-style:italic;
  color:red;
  text-transform:lowercase;
  text-align:center;
}
/*
  Success message
  ..................................
*/
div#yop-poll-container-success-%POLL-ID% {
  font-size:.8em;
  font-style:italic;
  color:green;
  text-align:center;
}
/*
  Poll Question
  ---------------------------------------------------------------------------
*/
div#yop-poll-questions-container-%POLL-ID% { margin:.5em; }
div.yop-poll-question-container-%POLL-ID% { margin: 0; }
div.yop-poll-question-%POLL-ID% {
  background:#327BD6;
  color:#fff;
  border: 0 none;
  margin: 0 0 2em;
  padding: .25em;
  text-align: center;
  font-size: 14px;
}
/*
  Poll Options / Answers
  ---------------------------------------------------------------------------
*/
div.yop-poll-answers-%POLL-ID% {}
div.yop-poll-answers-%POLL-ID% ul {
  list-style: none;
  margin: 0;
  padding: 0;

}
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-answer-%POLL-ID%,
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-result-%POLL-ID% {
  list-style: none;
  margin: 0;
  padding: 0;
  font-size: 14px;
  line-height: 2em;

}
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-result-%POLL-ID% {padding-bottom: 1em;}
/*
  Label
  ..................................
*/
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label {
  margin:0px;
  font-style:normal;
  font-weight:normal;
  font-size:14px;
  float:none;
  display:inline-block;
}
/* Actual text label of the answer */
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(2) {

}
/*
  Custom answer / Other
  ..................................
*/
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(3) {
  width: 100%;
  overflow: hidden;
}
div#yop-poll-container-%POLL-ID%  li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(3) input[type="text"] {
  width: 94%;
  overflow: hidden;
}
/*
  Custom checkbox and radio button style
  ---------------------------------------------------------------------------
*/


/*
  Custom fields
  ---------------------------------------------------------------------------
*/
div.yop-poll-customs-%POLL-ID% {
  clear: both;

}
div.yop-poll-customs-%POLL-ID% ul {
  list-style: none;
  margin: 0;
  padding: 0;
  overflow: hidden;
  width: 100%;
}
div.yop-poll-customs-%POLL-ID% ul li.yop-poll-li-custom-%POLL-ID% {
  display: block;
  font-size:14px;
  list-style: none;
}
div.yop-poll-customs-%POLL-ID% ul li.yop-poll-li-custom-%POLL-ID% label {
  display: block;
}
div#yop-poll-container-%POLL-ID% li.yop-poll-li-custom-%POLL-ID% input[type="text"] {
  width: 94%;
}
/*
  Vote Button
  ---------------------------------------------------------------------------
*/
.yop-poll-footer { /*height: 4em;*/ }

.yop-poll-vote-centered-%POLL-ID% { text-align:center; }

#yop-poll-vote-%POLL-ID% div button {

  cursor:pointer;
  display: block;
  font-size:14px;
  margin: 0 auto;
  }


#yop-poll-vote-%POLL-ID% div button.yop_poll_vote_button {}
#yop-poll-vote-%POLL-ID% div button.yop_poll_wordpress_vote_button { margin: 1em auto 0; }
#yop-poll-vote-%POLL-ID% div button.yop_poll_anonymous_vote_button { margin: 1em auto 0; }

/*
  Results
  ---------------------------------------------------------------------------
*/

li.yop-poll-results-%POLL-ID% {
  font-size: 12px;
  font-style: italic;
  font-weight: normal;
  margin-left: 15px;
  color: #38595E;
}
/*
  Style for results that are displayed on columns
  ..................................
*/
li.yop-poll-li-answer-%POLL-ID% {
  float: left;
  display: inline-block;
  width: 100%;
  padding: 1%;
  margin: 1%;
}

#yop-poll-vote-%POLL-ID% div#yop-poll-results-%POLL-ID% {
  float: right;
  width: auto;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-results-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-back-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-archive-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div {
  float:left;
  width:100%;
}
/*
  Result Bar
  ..................................
*/

.yop-poll-results-bar-%POLL-ID% div { background:#555; width:90%;}


/*
  ---------------------------------------------------------------------------
  EXTRAS
  ---------------------------------------------------------------------------
*/
/*
  CAPTCHA
  ..................................
*/
#yop-poll-captcha-input-div-%POLL-ID% { margin-top:5px; }
#yop-poll-captcha-helpers-div-%POLL-ID% {
  width:30px;
  float:left;
  margin-left:5px;
  height:0px;
}
#yop-poll-captcha-helpers-div-%POLL-ID% img { margin-bottom:2px; }
#yop-poll-captcha-image-div-%POLL-ID% { margin-bottom:5px; }
#yop_poll_captcha_image_%POLL-ID% { float:left; }

.yop-poll-clear-%POLL-ID% { clear:both; }

.yop-poll-name-%POLL-ID% { color:#38595E; font-size: 18px; }


.yop-poll-li-answer-%POLL-ID% label  img     { max-width: 98%; }
.yop-poll-li-result-%POLL-ID% label span img { max-width: 98%; }

.content { position :unset !important; }

div.yop-poll-container br,
div#yop-poll-container-%POLL-ID% br { display: none; }

div#yop_poll_vote_options_div-%POLL-ID% div:nth-last-of-type(1) { display: none; }
NOWDOC;
                break;
            }
            case 'Blue v3':
            { //Blue v3
                $css = <<<NOWDOC
/*
  Main Container
  ---------------------------------------------------------------------------
*/
#yop-poll-other-answer-%POLL-ID%-other {
    border:1px solid #000000;
    color:#000000;

}
.yop-poll-customfield-%POLL-ID% {
border:1px solid #000000;
    color:#000000;
}
div#yop-poll-container-%POLL-ID% {
  background:#fff;
  box-sizing: border-box;
  display: inline-block;
  font-size: 14px;
  color:#555;
  padding: 10px;
  width: %POLL-WIDTH%;
  zoom: 1;
  border: 5px solid #327BD6;
}
/* A nice little reset */
div.yop-poll-container * {

}

form#yop-poll-form-%POLL-ID% {

}
/*
  Error message
  ..................................
*/
div#yop-poll-container-error-%POLL-ID% {
  font-size:.8em;
  font-style:italic;
  color:red;
  text-transform:lowercase;
  text-align:center;
}
/*
  Success message
  ..................................
*/
div#yop-poll-container-success-%POLL-ID% {
  font-size:.8em;
  font-style:italic;
  color:green;
  text-align:center;
}
/*
  Poll Question
  ---------------------------------------------------------------------------
*/
div#yop-poll-questions-container-%POLL-ID% { margin:.5em; }
div.yop-poll-question-container-%POLL-ID% { margin: 0; }
div.yop-poll-question-%POLL-ID% {
  border: 0 none;
  margin: 0 0 2em;
  padding: .25em;
  text-align: center;
  font-size: 14px;
}
/*
  Poll Options / Answers
  ---------------------------------------------------------------------------
*/
div.yop-poll-answers-%POLL-ID% {}
div.yop-poll-answers-%POLL-ID% ul {
  list-style: none;
  margin: 0;
  padding: 0;

}
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-answer-%POLL-ID%,
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-result-%POLL-ID% {
  list-style: none;
  margin: 0;
  padding: 0;
  font-size: 14px;
  line-height: 2em;

}
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-result-%POLL-ID% {padding-bottom: 1em;}
/*
  Label
  ..................................
*/
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label {
  margin:0px;
  font-style:normal;
  font-weight:normal;
  font-size:14px;
  float:none;
  display:inline-block;
}
/* Actual text label of the answer */
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(2) {

}
/*
  Custom answer / Other
  ..................................
*/
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(3) {
  width: 100%;
  overflow: hidden;
}
div#yop-poll-container-%POLL-ID%  li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(3) input[type="text"] {
  width: 94%;
  overflow: hidden;
}
/*
  Custom checkbox and radio button style
  ---------------------------------------------------------------------------
*/


/*
  Custom fields
  ---------------------------------------------------------------------------
*/
div.yop-poll-customs-%POLL-ID% {
  clear: both;

}
div.yop-poll-customs-%POLL-ID% ul {
  list-style: none;
  margin: 0;
  padding: 0;
  overflow: hidden;
  width: 100%;
}
div.yop-poll-customs-%POLL-ID% ul li.yop-poll-li-custom-%POLL-ID% {
  display: block;
  font-size:14px;
  list-style: none;
}
div.yop-poll-customs-%POLL-ID% ul li.yop-poll-li-custom-%POLL-ID% label {
  display: block;
}
div#yop-poll-container-%POLL-ID% li.yop-poll-li-custom-%POLL-ID% input[type="text"] {
  width: 94%;
}
/*
  Vote Button
  ---------------------------------------------------------------------------
*/
.yop-poll-footer { /*height: 4em;*/ }

.yop-poll-vote-centered-%POLL-ID% { text-align:center; }

#yop-poll-vote-%POLL-ID% div button {

  cursor:pointer;
  display: block;
  font-size:14px;
  margin: 0 auto;
  }


#yop-poll-vote-%POLL-ID% div button.yop_poll_vote_button {}
#yop-poll-vote-%POLL-ID% div button.yop_poll_wordpress_vote_button { margin: 1em auto 0; }
#yop-poll-vote-%POLL-ID% div button.yop_poll_anonymous_vote_button { margin: 1em auto 0; }

/*
  Results
  ---------------------------------------------------------------------------
*/

li.yop-poll-results-%POLL-ID% {
  font-size: 12px;
  font-style: italic;
  font-weight: normal;
  margin-left: 15px;
  color: #38595E;
}
/*
  Style for results that are displayed on columns
  ..................................
*/
li.yop-poll-li-answer-%POLL-ID% {
  float: left;
  display: inline-block;
  width: 100%;
  padding: 1%;
  margin: 1%;
}

#yop-poll-vote-%POLL-ID% div#yop-poll-results-%POLL-ID% {
  float: right;
  width: auto;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-results-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-back-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-archive-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div {
  float:left;
  width:100%;
}
/*
  Result Bar
  ..................................
*/

.yop-poll-results-bar-%POLL-ID% div { background:#555; width:90%;}


/*
  ---------------------------------------------------------------------------
  EXTRAS
  ---------------------------------------------------------------------------
*/
/*
  CAPTCHA
  ..................................
*/
#yop-poll-captcha-input-div-%POLL-ID% { margin-top:5px; }
#yop-poll-captcha-helpers-div-%POLL-ID% {
  width:30px;
  float:left;
  margin-left:5px;
  height:0px;
}
#yop-poll-captcha-helpers-div-%POLL-ID% img { margin-bottom:2px; }
#yop-poll-captcha-image-div-%POLL-ID% { margin-bottom:5px; }
#yop_poll_captcha_image_%POLL-ID% { float:left; }

.yop-poll-clear-%POLL-ID% { clear:both; }

.yop-poll-name-%POLL-ID% { color:#38595E; font-size: 18px; }


.yop-poll-li-answer-%POLL-ID% label  img     { max-width: 98%; }
.yop-poll-li-result-%POLL-ID% label span img { max-width: 98%; }

.content { position :unset !important; }

div.yop-poll-container br,
div#yop-poll-container-%POLL-ID% br { display: none; }

div#yop_poll_vote_options_div-%POLL-ID% div:nth-last-of-type(1) { display: none; }
NOWDOC;
                break;
            }
            case 'Red v1':
            { //Red v1
                $css = <<<NOWDOC
/*
  Main Container
  ---------------------------------------------------------------------------
*/
#yop-poll-other-answer-%POLL-ID%-other {
    color:#000000;

}
.yop-poll-customfield-%POLL-ID% {
    color:#000000;
}
div#yop-poll-container-%POLL-ID% {
  background:#B70004;
  box-sizing: border-box;
  display: inline-block;
  font-size: 14px;
  color:white;
  padding: 10px;
  width: %POLL-WIDTH%;
  zoom: 1;
}
/* A nice little reset */
div.yop-poll-container * {

}

form#yop-poll-form-%POLL-ID% {

}
/*
  Error message
  ..................................
*/
div#yop-poll-container-error-%POLL-ID% {
  font-size:.8em;
  font-style:italic;
  color:red;
  text-transform:lowercase;
  text-align:center;
}
/*
  Success message
  ..................................
*/
div#yop-poll-container-success-%POLL-ID% {
  font-size:.8em;
  font-style:italic;
  color:green;
  text-align:center;
}
/*
  Poll Question
  ---------------------------------------------------------------------------
*/
div#yop-poll-questions-container-%POLL-ID% { margin:.5em; }
div.yop-poll-question-container-%POLL-ID% { margin: 0; }
div.yop-poll-question-%POLL-ID% {
  border: 0 none;
  margin: 0 0 2em;
  padding: .25em;
  text-align: center;
  font-size: 14px;
}
/*
  Poll Options / Answers
  ---------------------------------------------------------------------------
*/
div.yop-poll-answers-%POLL-ID% {}
div.yop-poll-answers-%POLL-ID% ul {
  list-style: none;
  margin: 0;
  padding: 0;

}
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-answer-%POLL-ID%,
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-result-%POLL-ID% {
  list-style: none;
  margin: 0;
  padding: 0;
  font-size: 14px;
  line-height: 2em;

}
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-result-%POLL-ID% {padding-bottom: 1em;}
/*
  Label
  ..................................
*/
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label {
  margin:0px;
  font-style:normal;
  font-weight:normal;
  font-size:14px;
  float:none;
  display:inline-block;
}
/* Actual text label of the answer */
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(2) {

}
/*
  Custom answer / Other
  ..................................
*/
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(3) {
  width: 100%;
  overflow: hidden;
}
div#yop-poll-container-%POLL-ID%  li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(3) input[type="text"] {
  width: 94%;
  overflow: hidden;
}
/*
  Custom checkbox and radio button style
  ---------------------------------------------------------------------------
*/


/*
  Custom fields
  ---------------------------------------------------------------------------
*/
div.yop-poll-customs-%POLL-ID% {
  clear: both;

}
div.yop-poll-customs-%POLL-ID% ul {
  list-style: none;
  margin: 0;
  padding: 0;
  overflow: hidden;
  width: 100%;
}
div.yop-poll-customs-%POLL-ID% ul li.yop-poll-li-custom-%POLL-ID% {
  display: block;
  font-size:14px;
  list-style: none;
}
div.yop-poll-customs-%POLL-ID% ul li.yop-poll-li-custom-%POLL-ID% label {
  display: block;
}
div#yop-poll-container-%POLL-ID% li.yop-poll-li-custom-%POLL-ID% input[type="text"] {
  width: 94%;
}
/*
  Vote Button
  ---------------------------------------------------------------------------
*/
.yop-poll-footer { /*height: 4em;*/ }

.yop-poll-vote-centered-%POLL-ID% { text-align:center; }

#yop-poll-vote-%POLL-ID% div button {

  cursor:pointer;
  display: block;
  font-size:14px;
  margin: 0 auto;
  }


#yop-poll-vote-%POLL-ID% div button.yop_poll_vote_button {}
#yop-poll-vote-%POLL-ID% div button.yop_poll_wordpress_vote_button { margin: 1em auto 0; }
#yop-poll-vote-%POLL-ID% div button.yop_poll_anonymous_vote_button { margin: 1em auto 0; }

/*
  Results
  ---------------------------------------------------------------------------
*/

li.yop-poll-results-%POLL-ID% {
  font-size: 12px;
  font-style: italic;
  font-weight: normal;
  margin-left: 15px;
  color: #38595E;
}
/*
  Style for results that are displayed on columns
  ..................................
*/
li.yop-poll-li-answer-%POLL-ID% {
  float: left;
  display: inline-block;
  width: 100%;
  padding: 1%;
  margin: 1%;
}

#yop-poll-vote-%POLL-ID% div#yop-poll-results-%POLL-ID% {
  float: right;
  width: auto;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-results-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-back-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-archive-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div {
  float:left;
  width:100%;
}
/*
  Result Bar
  ..................................
*/

.yop-poll-results-bar-%POLL-ID% div { background:#555; width:90%;}


/*
  ---------------------------------------------------------------------------
  EXTRAS
  ---------------------------------------------------------------------------
*/
/*
  CAPTCHA
  ..................................
*/
#yop-poll-captcha-input-div-%POLL-ID% { margin-top:5px; }
#yop-poll-captcha-helpers-div-%POLL-ID% {
  width:30px;
  float:left;
  margin-left:5px;
  height:0px;
}
#yop-poll-captcha-helpers-div-%POLL-ID% img { margin-bottom:2px; }
#yop-poll-captcha-image-div-%POLL-ID% { margin-bottom:5px; }
#yop_poll_captcha_image_%POLL-ID% { float:left; }

.yop-poll-clear-%POLL-ID% { clear:both; }

.yop-poll-name-%POLL-ID% { color:#38595E; font-size: 18px; }


.yop-poll-li-answer-%POLL-ID% label  img     { max-width: 98%; }
.yop-poll-li-result-%POLL-ID% label span img { max-width: 98%; }

.content { position :unset !important; }

div.yop-poll-container br,
div#yop-poll-container-%POLL-ID% br { display: none; }

div#yop_poll_vote_options_div-%POLL-ID% div:nth-last-of-type(1) { display: none; }
NOWDOC;
                break;
            }
            case 'Red v2':
            { //Red v2
                $css = <<<NOWDOC
/*
  Main Container
  ---------------------------------------------------------------------------
*/
#yop-poll-other-answer-%POLL-ID%-other {
    border:1px solid #000000;
    color:#000000;

}
.yop-poll-customfield-%POLL-ID% {
border:1px solid #000000;
    color:#000000;
}
div#yop-poll-container-%POLL-ID% {
  background:#fff;
  box-sizing: border-box;
  display: inline-block;
  font-size: 14px;
  color:#555;
  padding: 10px;
  width: %POLL-WIDTH%;
  zoom: 1;
}
/* A nice little reset */
div.yop-poll-container * {

}

form#yop-poll-form-%POLL-ID% {

}
/*
  Error message
  ..................................
*/
div#yop-poll-container-error-%POLL-ID% {
  font-size:.8em;
  font-style:italic;
  color:red;
  text-transform:lowercase;
  text-align:center;
}
/*
  Success message
  ..................................
*/
div#yop-poll-container-success-%POLL-ID% {
  font-size:.8em;
  font-style:italic;
  color:green;
  text-align:center;
}
/*
  Poll Question
  ---------------------------------------------------------------------------
*/
div#yop-poll-questions-container-%POLL-ID% { margin:.5em; }
div.yop-poll-question-container-%POLL-ID% { margin: 0; }
div.yop-poll-question-%POLL-ID% {
  background:#B70004;
  color:#fff;
  border: 0 none;
  margin: 0 0 2em;
  padding: .25em;
  text-align: center;
  font-size: 14px;
}
/*
  Poll Options / Answers
  ---------------------------------------------------------------------------
*/
div.yop-poll-answers-%POLL-ID% {}
div.yop-poll-answers-%POLL-ID% ul {
  list-style: none;
  margin: 0;
  padding: 0;

}
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-answer-%POLL-ID%,
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-result-%POLL-ID% {
  list-style: none;
  margin: 0;
  padding: 0;
  font-size: 14px;
  line-height: 2em;

}
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-result-%POLL-ID% {padding-bottom: 1em;}
/*
  Label
  ..................................
*/
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label {
  margin:0px;
  font-style:normal;
  font-weight:normal;
  font-size:14px;
  float:none;
  display:inline-block;
}
/* Actual text label of the answer */
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(2) {

}
/*
  Custom answer / Other
  ..................................
*/
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(3) {
  width: 100%;
  overflow: hidden;
}
div#yop-poll-container-%POLL-ID%  li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(3) input[type="text"] {
  width: 94%;
  overflow: hidden;
}
/*
  Custom checkbox and radio button style
  ---------------------------------------------------------------------------
*/


/*
  Custom fields
  ---------------------------------------------------------------------------
*/
div.yop-poll-customs-%POLL-ID% {
  clear: both;

}
div.yop-poll-customs-%POLL-ID% ul {
  list-style: none;
  margin: 0;
  padding: 0;
  overflow: hidden;
  width: 100%;
}
div.yop-poll-customs-%POLL-ID% ul li.yop-poll-li-custom-%POLL-ID% {
  display: block;
  font-size:14px;
  list-style: none;
}
div.yop-poll-customs-%POLL-ID% ul li.yop-poll-li-custom-%POLL-ID% label {
  display: block;
}
div#yop-poll-container-%POLL-ID% li.yop-poll-li-custom-%POLL-ID% input[type="text"] {
  width: 94%;
}
/*
  Vote Button
  ---------------------------------------------------------------------------
*/
.yop-poll-footer { /*height: 4em;*/ }

.yop-poll-vote-centered-%POLL-ID% { text-align:center; }

#yop-poll-vote-%POLL-ID% div button {

  cursor:pointer;
  display: block;
  font-size:14px;
  margin: 0 auto;
  }


#yop-poll-vote-%POLL-ID% div button.yop_poll_vote_button {}
#yop-poll-vote-%POLL-ID% div button.yop_poll_wordpress_vote_button { margin: 1em auto 0; }
#yop-poll-vote-%POLL-ID% div button.yop_poll_anonymous_vote_button { margin: 1em auto 0; }

/*
  Results
  ---------------------------------------------------------------------------
*/

li.yop-poll-results-%POLL-ID% {
  font-size: 12px;
  font-style: italic;
  font-weight: normal;
  margin-left: 15px;
  color: #38595E;
}
/*
  Style for results that are displayed on columns
  ..................................
*/
li.yop-poll-li-answer-%POLL-ID% {
  float: left;
  display: inline-block;
  width: 100%;
  padding: 1%;
  margin: 1%;
}

#yop-poll-vote-%POLL-ID% div#yop-poll-results-%POLL-ID% {
  float: right;
  width: auto;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-results-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-back-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-archive-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div {
  float:left;
  width:100%;
}
/*
  Result Bar
  ..................................
*/

.yop-poll-results-bar-%POLL-ID% div { background:#555; width:90%;}


/*
  ---------------------------------------------------------------------------
  EXTRAS
  ---------------------------------------------------------------------------
*/
/*
  CAPTCHA
  ..................................
*/
#yop-poll-captcha-input-div-%POLL-ID% { margin-top:5px; }
#yop-poll-captcha-helpers-div-%POLL-ID% {
  width:30px;
  float:left;
  margin-left:5px;
  height:0px;
}
#yop-poll-captcha-helpers-div-%POLL-ID% img { margin-bottom:2px; }
#yop-poll-captcha-image-div-%POLL-ID% { margin-bottom:5px; }
#yop_poll_captcha_image_%POLL-ID% { float:left; }

.yop-poll-clear-%POLL-ID% { clear:both; }

.yop-poll-name-%POLL-ID% { color:#38595E; font-size: 18px; }


.yop-poll-li-answer-%POLL-ID% label  img     { max-width: 98%; }
.yop-poll-li-result-%POLL-ID% label span img { max-width: 98%; }

.content { position :unset !important; }

div.yop-poll-container br,
div#yop-poll-container-%POLL-ID% br { display: none; }

div#yop_poll_vote_options_div-%POLL-ID% div:nth-last-of-type(1) { display: none; }
NOWDOC;
                break;
            }
            case 'Red v3':
            { //Red v3
                $css = <<<NOWDOC
/*
  Main Container
  ---------------------------------------------------------------------------
*/
#yop-poll-other-answer-%POLL-ID%-other {
    border:1px solid #000000;
    color:#000000;

}
.yop-poll-customfield-%POLL-ID% {
border:1px solid #000000;
    color:#000000;
}
div#yop-poll-container-%POLL-ID% {
  background:#fff;
  box-sizing: border-box;
  display: inline-block;
  font-size: 14px;
  color:#555;
  padding: 10px;
  width: %POLL-WIDTH%;
  zoom: 1;
  border:5px solid #B70004;
}
/* A nice little reset */
div.yop-poll-container * {

}

form#yop-poll-form-%POLL-ID% {

}
/*
  Error message
  ..................................
*/
div#yop-poll-container-error-%POLL-ID% {
  font-size:.8em;
  font-style:italic;
  color:red;
  text-transform:lowercase;
  text-align:center;
}
/*
  Success message
  ..................................
*/
div#yop-poll-container-success-%POLL-ID% {
  font-size:.8em;
  font-style:italic;
  color:green;
  text-align:center;
}
/*
  Poll Question
  ---------------------------------------------------------------------------
*/
div#yop-poll-questions-container-%POLL-ID% { margin:.5em; }
div.yop-poll-question-container-%POLL-ID% { margin: 0; }
div.yop-poll-question-%POLL-ID% {
  border: 0 none;
  margin: 0 0 2em;
  padding: .25em;
  text-align: center;
  font-size: 14px;
}
/*
  Poll Options / Answers
  ---------------------------------------------------------------------------
*/
div.yop-poll-answers-%POLL-ID% {}
div.yop-poll-answers-%POLL-ID% ul {
  list-style: none;
  margin: 0;
  padding: 0;

}
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-answer-%POLL-ID%,
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-result-%POLL-ID% {
  list-style: none;
  margin: 0;
  padding: 0;
  font-size: 14px;
  line-height: 2em;

}
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-result-%POLL-ID% {padding-bottom: 1em;}
/*
  Label
  ..................................
*/
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label {
  margin:0px;
  font-style:normal;
  font-weight:normal;
  font-size:14px;
  float:none;
  display:inline-block;
}
/* Actual text label of the answer */
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(2) {

}
/*
  Custom answer / Other
  ..................................
*/
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(3) {
  width: 100%;
  overflow: hidden;
}
div#yop-poll-container-%POLL-ID%  li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(3) input[type="text"] {
  width: 94%;
  overflow: hidden;
}
/*
  Custom checkbox and radio button style
  ---------------------------------------------------------------------------
*/


/*
  Custom fields
  ---------------------------------------------------------------------------
*/
div.yop-poll-customs-%POLL-ID% {
  clear: both;

}
div.yop-poll-customs-%POLL-ID% ul {
  list-style: none;
  margin: 0;
  padding: 0;
  overflow: hidden;
  width: 100%;
}
div.yop-poll-customs-%POLL-ID% ul li.yop-poll-li-custom-%POLL-ID% {
  display: block;
  font-size:14px;
  list-style: none;
}
div.yop-poll-customs-%POLL-ID% ul li.yop-poll-li-custom-%POLL-ID% label {
  display: block;
}
div#yop-poll-container-%POLL-ID% li.yop-poll-li-custom-%POLL-ID% input[type="text"] {
  width: 94%;
}
/*
  Vote Button
  ---------------------------------------------------------------------------
*/
.yop-poll-footer { /*height: 4em;*/ }

.yop-poll-vote-centered-%POLL-ID% { text-align:center; }

#yop-poll-vote-%POLL-ID% div button {

  cursor:pointer;
  display: block;
  font-size:14px;
  margin: 0 auto;
  }


#yop-poll-vote-%POLL-ID% div button.yop_poll_vote_button {}
#yop-poll-vote-%POLL-ID% div button.yop_poll_wordpress_vote_button { margin: 1em auto 0; }
#yop-poll-vote-%POLL-ID% div button.yop_poll_anonymous_vote_button { margin: 1em auto 0; }

/*
  Results
  ---------------------------------------------------------------------------
*/

li.yop-poll-results-%POLL-ID% {
  font-size: 12px;
  font-style: italic;
  font-weight: normal;
  margin-left: 15px;
  color: #38595E;
}
/*
  Style for results that are displayed on columns
  ..................................
*/
li.yop-poll-li-answer-%POLL-ID% {
  float: left;
  display: inline-block;
  width: 100%;
  padding: 1%;
  margin: 1%;
}

#yop-poll-vote-%POLL-ID% div#yop-poll-results-%POLL-ID% {
  float: right;
  width: auto;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-results-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-back-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-archive-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div {
  float:left;
  width:100%;
}
/*
  Result Bar
  ..................................
*/

.yop-poll-results-bar-%POLL-ID% div { background:#555; width:90%;}


/*
  ---------------------------------------------------------------------------
  EXTRAS
  ---------------------------------------------------------------------------
*/
/*
  CAPTCHA
  ..................................
*/
#yop-poll-captcha-input-div-%POLL-ID% { margin-top:5px; }
#yop-poll-captcha-helpers-div-%POLL-ID% {
  width:30px;
  float:left;
  margin-left:5px;
  height:0px;
}
#yop-poll-captcha-helpers-div-%POLL-ID% img { margin-bottom:2px; }
#yop-poll-captcha-image-div-%POLL-ID% { margin-bottom:5px; }
#yop_poll_captcha_image_%POLL-ID% { float:left; }

.yop-poll-clear-%POLL-ID% { clear:both; }

.yop-poll-name-%POLL-ID% { color:#38595E; font-size: 18px; }


.yop-poll-li-answer-%POLL-ID% label  img     { max-width: 98%; }
.yop-poll-li-result-%POLL-ID% label span img { max-width: 98%; }

.content { position :unset !important; }

div.yop-poll-container br,
div#yop-poll-container-%POLL-ID% br { display: none; }

div#yop_poll_vote_options_div-%POLL-ID% div:nth-last-of-type(1) { display: none; }
NOWDOC;
                break;
            }
            case 'Green v1':
            { //Green v1
                $css = <<<NOWDOC
/*
  Main Container
  ---------------------------------------------------------------------------
*/
#yop-poll-other-answer-%POLL-ID%-other {
    color:#000000;

}
.yop-poll-customfield-%POLL-ID% {
    color:#000000;
}
div#yop-poll-container-%POLL-ID% {
  background:#3F8B43;
  box-sizing: border-box;
  display: inline-block;
  font-size: 14px;
  color:white;
  padding: 10px;
  width: %POLL-WIDTH%;
  zoom: 1;
}
/* A nice little reset */
div.yop-poll-container * {

}

form#yop-poll-form-%POLL-ID% {

}
/*
  Error message
  ..................................
*/
div#yop-poll-container-error-%POLL-ID% {
  font-size:.8em;
  font-style:italic;
  color:red;
  text-transform:lowercase;
  text-align:center;
}
/*
  Success message
  ..................................
*/
div#yop-poll-container-success-%POLL-ID% {
  font-size:.8em;
  font-style:italic;
  color:green;
  text-align:center;
}
/*
  Poll Question
  ---------------------------------------------------------------------------
*/
div#yop-poll-questions-container-%POLL-ID% { margin:.5em; }
div.yop-poll-question-container-%POLL-ID% { margin: 0; }
div.yop-poll-question-%POLL-ID% {
  border: 0 none;
  margin: 0 0 2em;
  padding: .25em;
  text-align: center;
  font-size: 14px;
}
/*
  Poll Options / Answers
  ---------------------------------------------------------------------------
*/
div.yop-poll-answers-%POLL-ID% {}
div.yop-poll-answers-%POLL-ID% ul {
  list-style: none;
  margin: 0;
  padding: 0;

}
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-answer-%POLL-ID%,
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-result-%POLL-ID% {
  list-style: none;
  margin: 0;
  padding: 0;
  font-size: 14px;
  line-height: 2em;

}
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-result-%POLL-ID% {padding-bottom: 1em;}
/*
  Label
  ..................................
*/
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label {
  margin:0px;
  font-style:normal;
  font-weight:normal;
  font-size:14px;
  float:none;
  display:inline-block;
}
/* Actual text label of the answer */
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(2) {

}
/*
  Custom answer / Other
  ..................................
*/
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(3) {
  width: 100%;
  overflow: hidden;
}
div#yop-poll-container-%POLL-ID%  li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(3) input[type="text"] {
  width: 94%;
  overflow: hidden;
}
/*
  Custom checkbox and radio button style
  ---------------------------------------------------------------------------
*/


/*
  Custom fields
  ---------------------------------------------------------------------------
*/
div.yop-poll-customs-%POLL-ID% {
  clear: both;

}
div.yop-poll-customs-%POLL-ID% ul {
  list-style: none;
  margin: 0;
  padding: 0;
  overflow: hidden;
  width: 100%;
}
div.yop-poll-customs-%POLL-ID% ul li.yop-poll-li-custom-%POLL-ID% {
  display: block;
  font-size:14px;
  list-style: none;
}
div.yop-poll-customs-%POLL-ID% ul li.yop-poll-li-custom-%POLL-ID% label {
  display: block;
}
div#yop-poll-container-%POLL-ID% li.yop-poll-li-custom-%POLL-ID% input[type="text"] {
  width: 94%;
}
/*
  Vote Button
  ---------------------------------------------------------------------------
*/
.yop-poll-footer { /*height: 4em;*/ }

.yop-poll-vote-centered-%POLL-ID% { text-align:center; }

#yop-poll-vote-%POLL-ID% div button {

  cursor:pointer;
  display: block;
  font-size:14px;
  margin: 0 auto;
  }


#yop-poll-vote-%POLL-ID% div button.yop_poll_vote_button {}
#yop-poll-vote-%POLL-ID% div button.yop_poll_wordpress_vote_button { margin: 1em auto 0; }
#yop-poll-vote-%POLL-ID% div button.yop_poll_anonymous_vote_button { margin: 1em auto 0; }

/*
  Results
  ---------------------------------------------------------------------------
*/

li.yop-poll-results-%POLL-ID% {
  font-size: 12px;
  font-style: italic;
  font-weight: normal;
  margin-left: 15px;
  color: #38595E;
}
/*
  Style for results that are displayed on columns
  ..................................
*/
li.yop-poll-li-answer-%POLL-ID% {
  float: left;
  display: inline-block;
  width: 100%;
  padding: 1%;
  margin: 1%;
}

#yop-poll-vote-%POLL-ID% div#yop-poll-results-%POLL-ID% {
  float: right;
  width: auto;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-results-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-back-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-archive-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div {
  float:left;
  width:100%;
}
/*
  Result Bar
  ..................................
*/

.yop-poll-results-bar-%POLL-ID% div { background:#555; width:90%;}


/*
  ---------------------------------------------------------------------------
  EXTRAS
  ---------------------------------------------------------------------------
*/
/*
  CAPTCHA
  ..................................
*/
#yop-poll-captcha-input-div-%POLL-ID% { margin-top:5px; }
#yop-poll-captcha-helpers-div-%POLL-ID% {
  width:30px;
  float:left;
  margin-left:5px;
  height:0px;
}
#yop-poll-captcha-helpers-div-%POLL-ID% img { margin-bottom:2px; }
#yop-poll-captcha-image-div-%POLL-ID% { margin-bottom:5px; }
#yop_poll_captcha_image_%POLL-ID% { float:left; }

.yop-poll-clear-%POLL-ID% { clear:both; }

.yop-poll-name-%POLL-ID% { color:#38595E; font-size: 18px; }


.yop-poll-li-answer-%POLL-ID% label  img     { max-width: 98%; }
.yop-poll-li-result-%POLL-ID% label span img { max-width: 98%; }

.content { position :unset !important; }

div.yop-poll-container br,
div#yop-poll-container-%POLL-ID% br { display: none; }

div#yop_poll_vote_options_div-%POLL-ID% div:nth-last-of-type(1) { display: none; }
NOWDOC;
                break;
            }
            case 'Green v2':
            { //Green v2
                $css = <<<NOWDOC
/*
  Main Container
  ---------------------------------------------------------------------------
*/
#yop-poll-other-answer-%POLL-ID%-other {
    border:1px solid #000000;
    color:#000000;

}
.yop-poll-customfield-%POLL-ID% {
border:1px solid #000000;
    color:#000000;
}
div#yop-poll-container-%POLL-ID% {
  background:#fff;
  box-sizing: border-box;
  display: inline-block;
  font-size: 14px;
  color:#555;
  padding: 10px;
  width: %POLL-WIDTH%;
  zoom: 1;
}
/* A nice little reset */
div.yop-poll-container * {

}

form#yop-poll-form-%POLL-ID% {

}
/*
  Error message
  ..................................
*/
div#yop-poll-container-error-%POLL-ID% {
  font-size:.8em;
  font-style:italic;
  color:red;
  text-transform:lowercase;
  text-align:center;
}
/*
  Success message
  ..................................
*/
div#yop-poll-container-success-%POLL-ID% {
  font-size:.8em;
  font-style:italic;
  color:green;
  text-align:center;
}
/*
  Poll Question
  ---------------------------------------------------------------------------
*/
div#yop-poll-questions-container-%POLL-ID% { margin:.5em; }
div.yop-poll-question-container-%POLL-ID% { margin: 0; }
div.yop-poll-question-%POLL-ID% {
  background:#3F8B43;
  color:#fff;
  border: 0 none;
  margin: 0 0 2em;
  padding: .25em;
  text-align: center;
  font-size: 14px;
}
/*
  Poll Options / Answers
  ---------------------------------------------------------------------------
*/
div.yop-poll-answers-%POLL-ID% {}
div.yop-poll-answers-%POLL-ID% ul {
  list-style: none;
  margin: 0;
  padding: 0;

}
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-answer-%POLL-ID%,
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-result-%POLL-ID% {
  list-style: none;
  margin: 0;
  padding: 0;
  font-size: 14px;
  line-height: 2em;

}
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-result-%POLL-ID% {padding-bottom: 1em;}
/*
  Label
  ..................................
*/
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label {
  margin:0px;
  font-style:normal;
  font-weight:normal;
  font-size:14px;
  float:none;
  display:inline-block;
}
/* Actual text label of the answer */
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(2) {

}
/*
  Custom answer / Other
  ..................................
*/
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(3) {
  width: 100%;
  overflow: hidden;
}
div#yop-poll-container-%POLL-ID%  li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(3) input[type="text"] {
  width: 94%;
  overflow: hidden;
}
/*
  Custom checkbox and radio button style
  ---------------------------------------------------------------------------
*/


/*
  Custom fields
  ---------------------------------------------------------------------------
*/
div.yop-poll-customs-%POLL-ID% {
  clear: both;

}
div.yop-poll-customs-%POLL-ID% ul {
  list-style: none;
  margin: 0;
  padding: 0;
  overflow: hidden;
  width: 100%;
}
div.yop-poll-customs-%POLL-ID% ul li.yop-poll-li-custom-%POLL-ID% {
  display: block;
  font-size:14px;
  list-style: none;
}
div.yop-poll-customs-%POLL-ID% ul li.yop-poll-li-custom-%POLL-ID% label {
  display: block;
}
div#yop-poll-container-%POLL-ID% li.yop-poll-li-custom-%POLL-ID% input[type="text"] {
  width: 94%;
}
/*
  Vote Button
  ---------------------------------------------------------------------------
*/
.yop-poll-footer { /*height: 4em;*/ }

.yop-poll-vote-centered-%POLL-ID% { text-align:center; }

#yop-poll-vote-%POLL-ID% div button {

  cursor:pointer;
  display: block;
  font-size:14px;
  margin: 0 auto;
  }


#yop-poll-vote-%POLL-ID% div button.yop_poll_vote_button {}
#yop-poll-vote-%POLL-ID% div button.yop_poll_wordpress_vote_button { margin: 1em auto 0; }
#yop-poll-vote-%POLL-ID% div button.yop_poll_anonymous_vote_button { margin: 1em auto 0; }

/*
  Results
  ---------------------------------------------------------------------------
*/

li.yop-poll-results-%POLL-ID% {
  font-size: 12px;
  font-style: italic;
  font-weight: normal;
  margin-left: 15px;
  color: #38595E;
}
/*
  Style for results that are displayed on columns
  ..................................
*/
li.yop-poll-li-answer-%POLL-ID% {
  float: left;
  display: inline-block;
  width: 100%;
  padding: 1%;
  margin: 1%;
}

#yop-poll-vote-%POLL-ID% div#yop-poll-results-%POLL-ID% {
  float: right;
  width: auto;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-results-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-back-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-archive-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div {
  float:left;
  width:100%;
}
/*
  Result Bar
  ..................................
*/

.yop-poll-results-bar-%POLL-ID% div { background:#555; width:90%;}


/*
  ---------------------------------------------------------------------------
  EXTRAS
  ---------------------------------------------------------------------------
*/
/*
  CAPTCHA
  ..................................
*/
#yop-poll-captcha-input-div-%POLL-ID% { margin-top:5px; }
#yop-poll-captcha-helpers-div-%POLL-ID% {
  width:30px;
  float:left;
  margin-left:5px;
  height:0px;
}
#yop-poll-captcha-helpers-div-%POLL-ID% img { margin-bottom:2px; }
#yop-poll-captcha-image-div-%POLL-ID% { margin-bottom:5px; }
#yop_poll_captcha_image_%POLL-ID% { float:left; }

.yop-poll-clear-%POLL-ID% { clear:both; }

.yop-poll-name-%POLL-ID% { color:#38595E; font-size: 18px; }


.yop-poll-li-answer-%POLL-ID% label  img     { max-width: 98%; }
.yop-poll-li-result-%POLL-ID% label span img { max-width: 98%; }

.content { position :unset !important; }

div.yop-poll-container br,
div#yop-poll-container-%POLL-ID% br { display: none; }

div#yop_poll_vote_options_div-%POLL-ID% div:nth-last-of-type(1) { display: none; }

NOWDOC;
                break;
            }
            case 'Green v3':
            { //Green v3
                $css = <<<NOWDOC
/*
  Main Container
  ---------------------------------------------------------------------------
*/
#yop-poll-other-answer-%POLL-ID%-other {
    border:1px solid #000000;
    color:#000000;

}
.yop-poll-customfield-%POLL-ID% {
border:1px solid #000000;
    color:#000000;
}
div#yop-poll-container-%POLL-ID% {
  background:#fff;
  box-sizing: border-box;
  display: inline-block;
  font-size: 14px;
  color:#555;
  padding: 10px;
  width: %POLL-WIDTH%;
  zoom: 1;
  border:5px solid #3F8B43;
}
/* A nice little reset */
div.yop-poll-container * {

}

form#yop-poll-form-%POLL-ID% {

}
/*
  Error message
  ..................................
*/
div#yop-poll-container-error-%POLL-ID% {
  font-size:.8em;
  font-style:italic;
  color:red;
  text-transform:lowercase;
  text-align:center;
}
/*
  Success message
  ..................................
*/
div#yop-poll-container-success-%POLL-ID% {
  font-size:.8em;
  font-style:italic;
  color:green;
  text-align:center;
}
/*
  Poll Question
  ---------------------------------------------------------------------------
*/
div#yop-poll-questions-container-%POLL-ID% { margin:.5em; }
div.yop-poll-question-container-%POLL-ID% { margin: 0; }
div.yop-poll-question-%POLL-ID% {
  border: 0 none;
  margin: 0 0 2em;
  padding: .25em;
  text-align: center;
  font-size: 14px;
}
/*
  Poll Options / Answers
  ---------------------------------------------------------------------------
*/
div.yop-poll-answers-%POLL-ID% {}
div.yop-poll-answers-%POLL-ID% ul {
  list-style: none;
  margin: 0;
  padding: 0;

}
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-answer-%POLL-ID%,
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-result-%POLL-ID% {
  list-style: none;
  margin: 0;
  padding: 0;
  font-size: 14px;
  line-height: 2em;

}
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-result-%POLL-ID% {padding-bottom: 1em;}
/*
  Label
  ..................................
*/
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label {
  margin:0px;
  font-style:normal;
  font-weight:normal;
  font-size:14px;
  float:none;
  display:inline-block;
}
/* Actual text label of the answer */
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(2) {

}
/*
  Custom answer / Other
  ..................................
*/
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(3) {
  width: 100%;
  overflow: hidden;
}
div#yop-poll-container-%POLL-ID%  li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(3) input[type="text"] {
  width: 94%;
  overflow: hidden;
}
/*
  Custom checkbox and radio button style
  ---------------------------------------------------------------------------
*/


/*
  Custom fields
  ---------------------------------------------------------------------------
*/
div.yop-poll-customs-%POLL-ID% {
  clear: both;

}
div.yop-poll-customs-%POLL-ID% ul {
  list-style: none;
  margin: 0;
  padding: 0;
  overflow: hidden;
  width: 100%;
}
div.yop-poll-customs-%POLL-ID% ul li.yop-poll-li-custom-%POLL-ID% {
  display: block;
  font-size:14px;
  list-style: none;
}
div.yop-poll-customs-%POLL-ID% ul li.yop-poll-li-custom-%POLL-ID% label {
  display: block;
}
div#yop-poll-container-%POLL-ID% li.yop-poll-li-custom-%POLL-ID% input[type="text"] {
  width: 94%;
}
/*
  Vote Button
  ---------------------------------------------------------------------------
*/
.yop-poll-footer { /*height: 4em;*/ }

.yop-poll-vote-centered-%POLL-ID% { text-align:center; }

#yop-poll-vote-%POLL-ID% div button {

  cursor:pointer;
  display: block;
  font-size:14px;
  margin: 0 auto;
  }


#yop-poll-vote-%POLL-ID% div button.yop_poll_vote_button {}
#yop-poll-vote-%POLL-ID% div button.yop_poll_wordpress_vote_button { margin: 1em auto 0; }
#yop-poll-vote-%POLL-ID% div button.yop_poll_anonymous_vote_button { margin: 1em auto 0; }

/*
  Results
  ---------------------------------------------------------------------------
*/

li.yop-poll-results-%POLL-ID% {
  font-size: 12px;
  font-style: italic;
  font-weight: normal;
  margin-left: 15px;
  color: #38595E;
}
/*
  Style for results that are displayed on columns
  ..................................
*/
li.yop-poll-li-answer-%POLL-ID% {
  float: left;
  display: inline-block;
  width: 100%;
  padding: 1%;
  margin: 1%;
}

#yop-poll-vote-%POLL-ID% div#yop-poll-results-%POLL-ID% {
  float: right;
  width: auto;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-results-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-back-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-archive-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div {
  float:left;
  width:100%;
}
/*
  Result Bar
  ..................................
*/

.yop-poll-results-bar-%POLL-ID% div { background:#555; width:90%;}


/*
  ---------------------------------------------------------------------------
  EXTRAS
  ---------------------------------------------------------------------------
*/
/*
  CAPTCHA
  ..................................
*/
#yop-poll-captcha-input-div-%POLL-ID% { margin-top:5px; }
#yop-poll-captcha-helpers-div-%POLL-ID% {
  width:30px;
  float:left;
  margin-left:5px;
  height:0px;
}
#yop-poll-captcha-helpers-div-%POLL-ID% img { margin-bottom:2px; }
#yop-poll-captcha-image-div-%POLL-ID% { margin-bottom:5px; }
#yop_poll_captcha_image_%POLL-ID% { float:left; }

.yop-poll-clear-%POLL-ID% { clear:both; }

.yop-poll-name-%POLL-ID% { color:#38595E; font-size: 18px; }


.yop-poll-li-answer-%POLL-ID% label  img     { max-width: 98%; }
.yop-poll-li-result-%POLL-ID% label span img { max-width: 98%; }

.content { position :unset !important; }

div.yop-poll-container br,
div#yop-poll-container-%POLL-ID% br { display: none; }

div#yop_poll_vote_options_div-%POLL-ID% div:nth-last-of-type(1) { display: none; }
NOWDOC;
                break;
            }
            case 'Orange v1':
            { //Orange v1
                $css = <<<NOWDOC
/*
  Main Container
  ---------------------------------------------------------------------------
*/
#yop-poll-other-answer-%POLL-ID%-other {
    color:#000000;

}
.yop-poll-customfield-%POLL-ID% {
    color:#000000;
}
div#yop-poll-container-%POLL-ID% {
  background:#FB6911;
  box-sizing: border-box;
  display: inline-block;
  font-size: 14px;
  color:white;
  padding: 10px;
  width: %POLL-WIDTH%;
  zoom: 1;
}
/* A nice little reset */
div.yop-poll-container * {

}

form#yop-poll-form-%POLL-ID% {

}
/*
  Error message
  ..................................
*/
div#yop-poll-container-error-%POLL-ID% {
  font-size:.8em;
  font-style:italic;
  color:red;
  text-transform:lowercase;
  text-align:center;
}
/*
  Success message
  ..................................
*/
div#yop-poll-container-success-%POLL-ID% {
  font-size:.8em;
  font-style:italic;
  color:green;
  text-align:center;
}
/*
  Poll Question
  ---------------------------------------------------------------------------
*/
div#yop-poll-questions-container-%POLL-ID% { margin:.5em; }
div.yop-poll-question-container-%POLL-ID% { margin: 0; }
div.yop-poll-question-%POLL-ID% {
  border: 0 none;
  margin: 0 0 2em;
  padding: .25em;
  text-align: center;
  font-size: 14px;
}
/*
  Poll Options / Answers
  ---------------------------------------------------------------------------
*/
div.yop-poll-answers-%POLL-ID% {}
div.yop-poll-answers-%POLL-ID% ul {
  list-style: none;
  margin: 0;
  padding: 0;

}
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-answer-%POLL-ID%,
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-result-%POLL-ID% {
  list-style: none;
  margin: 0;
  padding: 0;
  font-size: 14px;
  line-height: 2em;

}
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-result-%POLL-ID% {padding-bottom: 1em;}
/*
  Label
  ..................................
*/
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label {
  margin:0px;
  font-style:normal;
  font-weight:normal;
  font-size:14px;
  float:none;
  display:inline-block;
}
/* Actual text label of the answer */
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(2) {

}
/*
  Custom answer / Other
  ..................................
*/
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(3) {
  width: 100%;
  overflow: hidden;
}
div#yop-poll-container-%POLL-ID%  li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(3) input[type="text"] {
  width: 94%;
  overflow: hidden;
}
/*
  Custom checkbox and radio button style
  ---------------------------------------------------------------------------
*/


/*
  Custom fields
  ---------------------------------------------------------------------------
*/
div.yop-poll-customs-%POLL-ID% {
  clear: both;

}
div.yop-poll-customs-%POLL-ID% ul {
  list-style: none;
  margin: 0;
  padding: 0;
  overflow: hidden;
  width: 100%;
}
div.yop-poll-customs-%POLL-ID% ul li.yop-poll-li-custom-%POLL-ID% {
  display: block;
  font-size:14px;
  list-style: none;
}
div.yop-poll-customs-%POLL-ID% ul li.yop-poll-li-custom-%POLL-ID% label {
  display: block;
}
div#yop-poll-container-%POLL-ID% li.yop-poll-li-custom-%POLL-ID% input[type="text"] {
  width: 94%;
}
/*
  Vote Button
  ---------------------------------------------------------------------------
*/
.yop-poll-footer { /*height: 4em;*/ }

.yop-poll-vote-centered-%POLL-ID% { text-align:center; }

#yop-poll-vote-%POLL-ID% div button {

  cursor:pointer;
  display: block;
  font-size:14px;
  margin: 0 auto;
  }


#yop-poll-vote-%POLL-ID% div button.yop_poll_vote_button {}
#yop-poll-vote-%POLL-ID% div button.yop_poll_wordpress_vote_button { margin: 1em auto 0; }
#yop-poll-vote-%POLL-ID% div button.yop_poll_anonymous_vote_button { margin: 1em auto 0; }

/*
  Results
  ---------------------------------------------------------------------------
*/

li.yop-poll-results-%POLL-ID% {
  font-size: 12px;
  font-style: italic;
  font-weight: normal;
  margin-left: 15px;
  color: #38595E;
}
/*
  Style for results that are displayed on columns
  ..................................
*/
li.yop-poll-li-answer-%POLL-ID% {
  float: left;
  display: inline-block;
  width: 100%;
  padding: 1%;
  margin: 1%;
}

#yop-poll-vote-%POLL-ID% div#yop-poll-results-%POLL-ID% {
  float: right;
  width: auto;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-results-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-back-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-archive-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div {
  float:left;
  width:100%;
}
/*
  Result Bar
  ..................................
*/

.yop-poll-results-bar-%POLL-ID% div { background:#555; width:90%;}


/*
  ---------------------------------------------------------------------------
  EXTRAS
  ---------------------------------------------------------------------------
*/
/*
  CAPTCHA
  ..................................
*/
#yop-poll-captcha-input-div-%POLL-ID% { margin-top:5px; }
#yop-poll-captcha-helpers-div-%POLL-ID% {
  width:30px;
  float:left;
  margin-left:5px;
  height:0px;
}
#yop-poll-captcha-helpers-div-%POLL-ID% img { margin-bottom:2px; }
#yop-poll-captcha-image-div-%POLL-ID% { margin-bottom:5px; }
#yop_poll_captcha_image_%POLL-ID% { float:left; }

.yop-poll-clear-%POLL-ID% { clear:both; }

.yop-poll-name-%POLL-ID% { color:#38595E; font-size: 18px; }


.yop-poll-li-answer-%POLL-ID% label  img     { max-width: 98%; }
.yop-poll-li-result-%POLL-ID% label span img { max-width: 98%; }

.content { position :unset !important; }

div.yop-poll-container br,
div#yop-poll-container-%POLL-ID% br { display: none; }

div#yop_poll_vote_options_div-%POLL-ID% div:nth-last-of-type(1) { display: none; }

NOWDOC;
                break;
            }
            case 'Orange v2':
            { //Orange v2
                $css = <<<NOWDOC
/*
  Main Container
  ---------------------------------------------------------------------------
*/
#yop-poll-other-answer-%POLL-ID%-other {
    border:1px solid #000000;
    color:#000000;

}
.yop-poll-customfield-%POLL-ID% {
border:1px solid #000000;
    color:#000000;
}
div#yop-poll-container-%POLL-ID% {
  background:#fff;
  box-sizing: border-box;
  display: inline-block;
  font-size: 14px;
  color:#555;
  padding: 10px;
  width: %POLL-WIDTH%;
  zoom: 1;
}
/* A nice little reset */
div.yop-poll-container * {

}

form#yop-poll-form-%POLL-ID% {

}
/*
  Error message
  ..................................
*/
div#yop-poll-container-error-%POLL-ID% {
  font-size:.8em;
  font-style:italic;
  color:red;
  text-transform:lowercase;
  text-align:center;
}
/*
  Success message
  ..................................
*/
div#yop-poll-container-success-%POLL-ID% {
  font-size:.8em;
  font-style:italic;
  color:green;
  text-align:center;
}
/*
  Poll Question
  ---------------------------------------------------------------------------
*/
div#yop-poll-questions-container-%POLL-ID% { margin:.5em; }
div.yop-poll-question-container-%POLL-ID% { margin: 0; }
div.yop-poll-question-%POLL-ID% {
  background:#FB6911;
  color:#fff;
  border: 0 none;
  margin: 0 0 2em;
  padding: .25em;
  text-align: center;
  font-size: 14px;
}
/*
  Poll Options / Answers
  ---------------------------------------------------------------------------
*/
div.yop-poll-answers-%POLL-ID% {}
div.yop-poll-answers-%POLL-ID% ul {
  list-style: none;
  margin: 0;
  padding: 0;

}
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-answer-%POLL-ID%,
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-result-%POLL-ID% {
  list-style: none;
  margin: 0;
  padding: 0;
  font-size: 14px;
  line-height: 2em;

}
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-result-%POLL-ID% {padding-bottom: 1em;}
/*
  Label
  ..................................
*/
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label {
  margin:0px;
  font-style:normal;
  font-weight:normal;
  font-size:14px;
  float:none;
  display:inline-block;
}
/* Actual text label of the answer */
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(2) {

}
/*
  Custom answer / Other
  ..................................
*/
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(3) {
  width: 100%;
  overflow: hidden;
}
div#yop-poll-container-%POLL-ID%  li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(3) input[type="text"] {
  width: 94%;
  overflow: hidden;
}
/*
  Custom checkbox and radio button style
  ---------------------------------------------------------------------------
*/


/*
  Custom fields
  ---------------------------------------------------------------------------
*/
div.yop-poll-customs-%POLL-ID% {
  clear: both;

}
div.yop-poll-customs-%POLL-ID% ul {
  list-style: none;
  margin: 0;
  padding: 0;
  overflow: hidden;
  width: 100%;
}
div.yop-poll-customs-%POLL-ID% ul li.yop-poll-li-custom-%POLL-ID% {
  display: block;
  font-size:14px;
  list-style: none;
}
div.yop-poll-customs-%POLL-ID% ul li.yop-poll-li-custom-%POLL-ID% label {
  display: block;
}
div#yop-poll-container-%POLL-ID% li.yop-poll-li-custom-%POLL-ID% input[type="text"] {
  width: 94%;
}
/*
  Vote Button
  ---------------------------------------------------------------------------
*/
.yop-poll-footer { /*height: 4em;*/ }

.yop-poll-vote-centered-%POLL-ID% { text-align:center; }

#yop-poll-vote-%POLL-ID% div button {

  cursor:pointer;
  display: block;
  font-size:14px;
  margin: 0 auto;
  }


#yop-poll-vote-%POLL-ID% div button.yop_poll_vote_button {}
#yop-poll-vote-%POLL-ID% div button.yop_poll_wordpress_vote_button { margin: 1em auto 0; }
#yop-poll-vote-%POLL-ID% div button.yop_poll_anonymous_vote_button { margin: 1em auto 0; }

/*
  Results
  ---------------------------------------------------------------------------
*/

li.yop-poll-results-%POLL-ID% {
  font-size: 12px;
  font-style: italic;
  font-weight: normal;
  margin-left: 15px;
  color: #38595E;
}
/*
  Style for results that are displayed on columns
  ..................................
*/
li.yop-poll-li-answer-%POLL-ID% {
  float: left;
  display: inline-block;
  width: 100%;
  padding: 1%;
  margin: 1%;
}

#yop-poll-vote-%POLL-ID% div#yop-poll-results-%POLL-ID% {
  float: right;
  width: auto;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-results-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-back-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-archive-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div {
  float:left;
  width:100%;
}
/*
  Result Bar
  ..................................
*/

.yop-poll-results-bar-%POLL-ID% div { background:#555; width:90%;}


/*
  ---------------------------------------------------------------------------
  EXTRAS
  ---------------------------------------------------------------------------
*/
/*
  CAPTCHA
  ..................................
*/
#yop-poll-captcha-input-div-%POLL-ID% { margin-top:5px; }
#yop-poll-captcha-helpers-div-%POLL-ID% {
  width:30px;
  float:left;
  margin-left:5px;
  height:0px;
}
#yop-poll-captcha-helpers-div-%POLL-ID% img { margin-bottom:2px; }
#yop-poll-captcha-image-div-%POLL-ID% { margin-bottom:5px; }
#yop_poll_captcha_image_%POLL-ID% { float:left; }

.yop-poll-clear-%POLL-ID% { clear:both; }

.yop-poll-name-%POLL-ID% { color:#38595E; font-size: 18px; }


.yop-poll-li-answer-%POLL-ID% label  img     { max-width: 98%; }
.yop-poll-li-result-%POLL-ID% label span img { max-width: 98%; }

.content { position :unset !important; }

div.yop-poll-container br,
div#yop-poll-container-%POLL-ID% br { display: none; }

div#yop_poll_vote_options_div-%POLL-ID% div:nth-last-of-type(1) { display: none; }
NOWDOC;
                break;
            }
            case 'Orange v3':
            { //Orange v3
                $css = <<<NOWDOC
/*
  Main Container
  ---------------------------------------------------------------------------
*/
#yop-poll-other-answer-%POLL-ID%-other {
    border:1px solid #000000;
    color:#000000;

}
.yop-poll-customfield-%POLL-ID% {
border:1px solid #000000;
    color:#000000;
}
div#yop-poll-container-%POLL-ID% {
  background:#fff;
  box-sizing: border-box;
  display: inline-block;
  font-size: 14px;
  color:#555;
  padding: 10px;
  width: %POLL-WIDTH%;
  zoom: 1;
  border:5px solid #FB6911;
}
/* A nice little reset */
div.yop-poll-container * {

}

form#yop-poll-form-%POLL-ID% {

}
/*
  Error message
  ..................................
*/
div#yop-poll-container-error-%POLL-ID% {
  font-size:.8em;
  font-style:italic;
  color:red;
  text-transform:lowercase;
  text-align:center;
}
/*
  Success message
  ..................................
*/
div#yop-poll-container-success-%POLL-ID% {
  font-size:.8em;
  font-style:italic;
  color:green;
  text-align:center;
}
/*
  Poll Question
  ---------------------------------------------------------------------------
*/
div#yop-poll-questions-container-%POLL-ID% { margin:.5em; }
div.yop-poll-question-container-%POLL-ID% { margin: 0; }
div.yop-poll-question-%POLL-ID% {
  border: 0 none;
  margin: 0 0 2em;
  padding: .25em;
  text-align: center;
  font-size: 14px;
}
/*
  Poll Options / Answers
  ---------------------------------------------------------------------------
*/
div.yop-poll-answers-%POLL-ID% {}
div.yop-poll-answers-%POLL-ID% ul {
  list-style: none;
  margin: 0;
  padding: 0;

}
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-answer-%POLL-ID%,
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-result-%POLL-ID% {
  list-style: none;
  margin: 0;
  padding: 0;
  font-size: 14px;
  line-height: 2em;

}
div.yop-poll-answers-%POLL-ID% ul li.yop-poll-li-result-%POLL-ID% {padding-bottom: 1em;}
/*
  Label
  ..................................
*/
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label {
  margin:0px;
  font-style:normal;
  font-weight:normal;
  font-size:14px;
  float:none;
  display:inline-block;
}
/* Actual text label of the answer */
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(2) {
}
/*
  Custom answer / Other
  ..................................
*/
div.yop-poll-answers-%POLL-ID%  ul li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(3) {
  width: 100%;
  overflow: hidden;
}
div#yop-poll-container-%POLL-ID%  li.yop-poll-li-answer-%POLL-ID% label:nth-of-type(3) input[type="text"] {
  width: 94%;
  overflow: hidden;
}
/*
  Custom checkbox and radio button style
  ---------------------------------------------------------------------------
*/


/*
  Custom fields
  ---------------------------------------------------------------------------
*/
div.yop-poll-customs-%POLL-ID% {
  clear: both;

}
div.yop-poll-customs-%POLL-ID% ul {
  list-style: none;
  margin: 0;
  padding: 0;
  overflow: hidden;
  width: 100%;
}
div.yop-poll-customs-%POLL-ID% ul li.yop-poll-li-custom-%POLL-ID% {
  display: block;
  font-size:14px;
  list-style: none;
}
div.yop-poll-customs-%POLL-ID% ul li.yop-poll-li-custom-%POLL-ID% label {
  display: block;
}
div#yop-poll-container-%POLL-ID% li.yop-poll-li-custom-%POLL-ID% input[type="text"] {
  width: 94%;
}
/*
  Vote Button
  ---------------------------------------------------------------------------
*/
.yop-poll-footer { /*height: 4em;*/ }

.yop-poll-vote-centered-%POLL-ID% { text-align:center; }

#yop-poll-vote-%POLL-ID% div button {

  cursor:pointer;
  display: block;
  font-size:14px;
  margin: 0 auto;
  }


#yop-poll-vote-%POLL-ID% div button.yop_poll_vote_button {}
#yop-poll-vote-%POLL-ID% div button.yop_poll_wordpress_vote_button { margin: 1em auto 0; }
#yop-poll-vote-%POLL-ID% div button.yop_poll_anonymous_vote_button { margin: 1em auto 0; }

/*
  Results
  ---------------------------------------------------------------------------
*/

li.yop-poll-results-%POLL-ID% {
  font-size: 12px;
  font-style: italic;
  font-weight: normal;
  margin-left: 15px;
  color: #38595E;
}
/*
  Style for results that are displayed on columns
  ..................................
*/
li.yop-poll-li-answer-%POLL-ID% {
  float: left;
  display: inline-block;
  width: 100%;
  padding: 1%;
  margin: 1%;
}

#yop-poll-vote-%POLL-ID% div#yop-poll-results-%POLL-ID% {
  float: right;
  width: auto;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-results-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-back-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div#yop-poll-archive-%POLL-ID% a {
  color:#000;
  text-decoration:underline;
  font-size:12px;
}
#yop-poll-vote-%POLL-ID% div {
  float:left;
  width:100%;
}
/*
  Result Bar
  ..................................
*/

.yop-poll-results-bar-%POLL-ID% div { background:#555; width:90%;}


/*
  ---------------------------------------------------------------------------
  EXTRAS
  ---------------------------------------------------------------------------
*/
/*
  CAPTCHA
  ..................................
*/
#yop-poll-captcha-input-div-%POLL-ID% { margin-top:5px; }
#yop-poll-captcha-helpers-div-%POLL-ID% {
  width:30px;
  float:left;
  margin-left:5px;
  height:0px;
}
#yop-poll-captcha-helpers-div-%POLL-ID% img { margin-bottom:2px; }
#yop-poll-captcha-image-div-%POLL-ID% { margin-bottom:5px; }
#yop_poll_captcha_image_%POLL-ID% { float:left; }

.yop-poll-clear-%POLL-ID% { clear:both; }

.yop-poll-name-%POLL-ID% { color:#38595E; font-size: 18px; }


.yop-poll-li-answer-%POLL-ID% label  img     { max-width: 98%; }
.yop-poll-li-result-%POLL-ID% label span img { max-width: 98%; }

.content { position :unset !important; }

div.yop-poll-container br,
div#yop-poll-container-%POLL-ID% br { display: none; }

div#yop_poll_vote_options_div-%POLL-ID% div:nth-last-of-type(1) { display: none; }








NOWDOC;
                break;
            }
        }

        $css.= "#yop-poll-container-%POLL-ID% img {
    max-width: %POLL-WIDTH%;
}";
        $css = addslashes($css);
        $before_vote_template = addslashes( $before_vote_template );

        $sql .= "`before_vote_template` = '{$before_vote_template}',
			`after_vote_template`           = '{$after_vote_template}',
			`before_start_date_template`    = '{$before_start_date_template}',
			`after_end_date_template`       = '{$after_end_date_template}',
			`js`                            = '$js',
			`css`                           = '{$css}',
			`last_modified`                 = '" . current_time( 'mysql' ) . "'";


        $sql .= $wpdb->prepare( ' WHERE name = %s', $template_to_reset );

        return $wpdb->query( $sql );

    }

}
function force_default_editor() {

    return 'html';
}
?>