/**
 * Video player
 */
;(function($){
	
	$.fn.YVII_VideoPlayer = function(options){
		
		if( 0 == this.length ){ 
				return false; 
		}
		
		// support multiple elements
       	if (this.length > 1){
       		this.each(function() { 
				$(this).YVII_VideoPlayer(options);				
			});
       		return;
       	}
		
       	var yt_player_defaults = {
       		'controls' 			: 1,
       		'autohide' 			: 0,
       		'fs'				: 1,
       		'theme'				: 'dark',
       		'color'				: 'red',
       		'iv_load_policy' 	: 1,
       		'modestbranding'	: 1,
       		'rel'				: 1,
       		'showinfo'			: 0,
       		'autoplay'			: 0,
       		'loop'				: 0,
       		'disablekb'			: 0
       	};
       	
       	var defaults = {
       		'video_id' 		: null,
       		'source' 		: 'youtube',
       		'width' 		: '100%',
       		'height'		: '100%',
       		'play'			: 0,
       		'volume'		: 30,
       		// get options from element
			'elem_data'	: false,			
       		// event
       		'stateChange' 	: function(){}
       	};
       	
       	
       	// variables       	
		var self 			= this,
			options 		= $.extend({}, defaults, options),
			playerId 		= false, // stores the player ID generated by the script
			containerId 	= false, // stores ID of the container
			player 			= false, // stores the player reference
			playerData		= false,
			playerStatus 	= false; // false - not loaded, 1 - ready, 2 - playing, 3 - paused, 4 - stopped			
		
		var initialize = function(){
			
			// store video data on video container				
			var id = generateIds(); // container and player unique ids
			
			if( options.elem_data ){
				var data = decodeParams( $(self).html() );
				options = $.extend({}, defaults, data);
			}
			
			// set unique id on container
			$(self).attr('id', id.cid).empty().append('<div id="'+id.pid+'"></div>');
			
			// store players ids for later reference
			containerId = id.cid;
			playerId 	= id.pid;
			
			// load the player
			loadFlashPlayer();
			
			// responsive
			resizePlayer();			
			$(window).resize(function(){
				resizePlayer();
			});
			
			return self;
		};
		
		var resizePlayer = function(){
			var width = $('#'+containerId).width(),
				height;
			
			switch( options.aspect_ratio ){
				case '16x9':
				default:
					height = (width *  9) / 16;
				break;
				case '4x3':
				height = (width *  3) / 4;
				break;
			}
			
			$('#'+containerId).height( Math.floor( height ) );			
		}
		
		/**
		 * Parses raw params stored inside the element as HTML comment
		 * and returns an object.
		 */
		var decodeParams = function( raw_data ){
			return $(self).data();
			//return $.parseJSON( raw_data.replace(/<!--|-->/g, '') );
		}
				
		/**
		 * Combines general params ( vidDefaultParams ) with player
		 * specific params for youtube
		 * */
		var playerParams = function(){
			var defaults = {};
			
			$.each( yt_player_defaults, function(i, val){
				if( options[i] != undefined ){
					defaults[i] = options[i];
				}else{
					defaults[i] = val;
				}
			})
			
			if( 0 == defaults.modestbranding ){
				delete defaults.modestbranding;
			}
						
			// youtube specific params
			defaults.enablejsapi = 1;
			defaults.playerapiid = playerId;
			
			return defaults;
		}
		
		/**
		 * Generates unique ID's for player and player container
		 */
		var generateIds = function(){
			var cid 	= 'YVII_videoPlayerContainer_', // container id prefix
				pid 	= 'YVIIVideoPlayer', // player id prefix
				uid 	= Math.floor(Math.random()*1000),
				result 	= {}; // unique ID
			
			result.cid = cid+uid;
			result.pid = pid+uid;
			
			return result;
		}
		
		/**
		 * Depending on source, retrieves the player url
		 */
		var getFlashPlayerUrl = function(){			
			var v = playerParams();			
			return 'https://www.youtube.com/v/' + options.video_id + '?version=3&rel='+v.rel;
		}
		
		/**
		 * Embeds the flash player using swfobject
		 */
		var loadFlashPlayer = function(){
			// player params
			var params = {
				allowfullscreen		: "true", 
				wmode				: "transparent", 
				allowScriptAccess	: "always"
			};
			// player atts
			var attributes = {
				id	: playerId, 
				name: playerId
			};
			
			swfobject.embedSWF(
				getFlashPlayerUrl(), 
				playerId, 
				'100%',
				'100%', 
				'8', 
				false,
				playerParams(),
				params,
				attributes,
				swfobjectCallback // callback funciton to check if Flash player has loaded
			);			
		}
		
		var swfobjectCallback = function(d){
			// if swf loaded successfully, proceed with flash player actions
			if( d.success ){
				//doAction('load');
			}else{
				// flash isn't available, try the HTML5 players
				// if source is youtube, load the API				
				if( !this.yt_api_loaded ){
					$.getScript('https://www.youtube.com/player_api');
					this.yt_api_loaded = true;
				}
				if( !YVII_YT_API_LOADED ){
					self.interval = setInterval( function(){
						loadYTplayer();
					}, 1000);
					return;						
				}					
								
			}	
		}
		
		// load YouTube HTML5 player
		var loadYTplayer = function(){
			if( !YVII_YT_API_LOADED ){
				return;
			}
			
			clearInterval(self.interval);
			
			new YT.Player(playerId, {
				height		: '100%',
				width		: '100%',
				videoId		: options.video_id,
				playerVars	: playerParams(),
				events: {
					 'onReady': function( event ){
						 player = event.target;
						 player.setVolume(options.volume);
						 playerStatus = 1;
						// store player reference on container
						 $('#'+containerId).data( 'player', player );
					 },
					 'onStateChange': function( object ){
						 var state = object.data;
						 switch( state ){
				    		case 0:
				    			self.updateStatus(4);
				    		break;
				    		case 1:
				    			self.updateStatus(2);
				    		break;
				    		case 2:
				    			self.updateStatus(3);
				    		break;	
				    	}
					 }
				}
	        });			
		}
		
		/**
		 * Plays, pauses or stops video
		 */
		var doAction = function( action, value ){
			
			// when player is ready, it will set ready param on container. Check it.
			if( !playerStatus ){
				setTimeout( function(){
					doAction( action );
				}, 100);
				return;
			}
			
			// different platforms have different function names. Map them here.	
			var funcs = {				
				'play' 			: 'playVideo',
				'pause' 		: 'pauseVideo',
				'stop' 			: 'stopVideo',
				'volume' 		: 'setVolume',
				'cueVideo'		: 'cueVideoById',
				'volumeDivider' : 1				
			};
			
			// status of player is ready
			playerStatus = 1;
			
			// get the player object
			if( !player ){
				player = document.getElementById(playerId);
				// if player isn't set, must be first run. Set the player volume
				var volFunc = funcs['volume'],
					volume = ( options.volume == undefined ? 10 : options.volume ) / funcs['volumeDivider'];				
				
				player[volFunc](volume);
				// store player reference on container
				$('#'+containerId).data( 'player', player );				
			}
			
			// if loading action was triggered, stop here
			if( 'load' == action ){
				return;
			}
			
			// function of player to call
			var func = funcs[action];
			// call function
			if( typeof value != 'undefined' ){
				player[func]( value );
			}else{
				player[func]();
			}
						
			// change player status
			switch( action ){
				case 'play':
					playerStatus = 2;
				break;
				case 'pause':
					playerStatus = 3;
				break;
				case 'stop':
					playerStatus = 4;
				break;
			}	
			options.stateChange.call(self, playerStatus);
		}
		
		/**
		 * Play video
		 */
		this.play = function(){			
			doAction('play');			
		};
		
		/**
		 * Pause video
		 */
		this.pause = function(){
			doAction('pause');
		};		
		
		/**
		 * Stop video
		 */
		this.stop = function(){
			doAction('stop');
		};
		
		/**
		 * Load video by id
		 */
		this.load = function( video_id ){
			doAction('cueVideo', video_id);
		}
		
		this.setVolume = function( vol ){
			doAction('volume', vol);
		}
		
		/**
		 * Returns the player settings
		 */
		this.getData = function(){
			return options;
		}
		
		/**
		 * Returns the current player status.
		 * Values: 
		 * - false 	: player not initialized
		 * - 1 		: player is ready
		 * - 2		: playing
		 * - 3		: paused
		 * - 4		: ended
		 */
		this.getStatus = function(){
			return playerStatus;
		}
		
		this.updateStatus = function( status ){
			
			if( status == 1 ){
				doAction('volume');
			}
			
			playerStatus = status;
			options.stateChange.call(self, status);				
		}
		
		$(this).data('ref', this);
		return initialize();			
	};	
})(jQuery);

/****************************************************************************
 * FLASH PLAYERS
 ****************************************************************************/

/* YouTube Flash Player callback */
var YVII_YT_PLAYERS = {};
function onYouTubePlayerReady( pid ){
	var playerContainer = pid.replace('YVIIVideoPlayer', '#YVII_videoPlayerContainer_');	
	jQuery(playerContainer).data('ref').updateStatus( 1 );
	
	var player = document.getElementById( pid ),
		p = jQuery( pid.replace('YVIIVideoPlayer', '#YVII_videoPlayerContainer_') );
	
	// hack for change event on youtube player to support multiple players
	var idPlayerParams = 'yt' + Math.floor (Math.random()*100000); // create random variable name
	YVII_YT_PLAYERS[idPlayerParams] = {
		idPlayer: pid,
	    onStateChanged: function (state) {
	    	switch( state ){
	    		case 0:
	    			p.data('ref').updateStatus( 4 );
	    		break;
	    		case 1:
	    			p.data('ref').updateStatus( 2 );
	    		break;
	    		case 2:
	    			p.data('ref').updateStatus( 3 );
	    		break;	
	    	}
	    }
	};
	player.addEventListener ('onStateChange', 'YVII_YT_PLAYERS.' + idPlayerParams + '.onStateChanged');
}

/******************************************************************************
 * HTML5 PLAYERS
 ******************************************************************************/

// YouTube
var YVII_YT_API_LOADED = false;

;(function($){
	$(document).ready(function(){
		//*
		window.onYouTubePlayerAPIReady = function(){
			YVII_YT_API_LOADED = true;
		}
		//*/
		$('div.yvii_single_video_player').YVII_VideoPlayer({'elem_data' : true});		
	})
})(jQuery);
