# Contributing to Magento 2 code

Contributions to the Magento 2 codebase are done using the fork & pull model.
This contribution model has contributors maintaining their own fork of the Magento 2 repository.
The forked repository is then used to submit a request to the base repository to “pull” a set of changes.
For more information on pull requests please refer to [GitHub Help](https://help.github.com/articles/about-pull-requests/).

Contributions can take the form of new components or features, changes to existing features, tests, documentation (such as developer guides, user guides, examples, or specifications), bug fixes or optimizations.

The Magento 2 development team or community maintainers will review all issues and contributions submitted by the community of developers in the first in, first out order.
During the review we might require clarifications from the contributor.
If there is no response from the contributor within two weeks, the pull request will be closed.

For more detailed information on contribution please read our [beginners guide](https://github.com/magento/magento2/wiki/Getting-Started).

## Contribution requirements

1. Contributions must adhere to the [Magento coding standards](https://devdocs.magento.com/guides/v2.3/coding-standards/bk-coding-standards.html).
2. Pull requests (PRs) must be accompanied by a meaningful description of their purpose. Comprehensive descriptions increase the chances of a pull request being merged quickly and without additional clarification requests.
3. Commits must be accompanied by meaningful commit messages. Please see the [Magento Pull Request Template](https://github.com/magento/magento2/blob/2.3-develop/.github/PULL_REQUEST_TEMPLATE.md) for more information.
4. PRs which include bug fixes must be accompanied with a step-by-step description of how to reproduce the bug.
3. PRs which include new logic or new features must be submitted along with:
* Unit/integration test coverage
* Proposed [documentation](https://devdocs.magento.com) updates. Documentation contributions can be submitted via the [devdocs GitHub](https://github.com/magento/devdocs).
4. For larger features or changes, please [open an issue](https://github.com/magento/magento2/issues) to discuss the proposed changes prior to development. This may prevent duplicate or unnecessary effort and allow other contributors to provide input.
5. All automated tests must pass (all builds on [Travis CI](https://travis-ci.org/magento/magento2) must be green).

## Contribution process

If you are a new GitHub user, we recommend that you create your own [free github account](https://github.com/signup/free).
This will allow you to collaborate with the Magento 2 development team, fork the Magento 2 project and send pull requests.

1. Search current [listed issues](https://github.com/magento/magento2/issues) (open or closed) for similar proposals of intended contribution before starting work on a new contribution.
2. Review the [Contributor License Agreement](https://magento.com/legaldocuments/mca) if this is your first time contributing.
3. Create and test your work.
4. Fork the Magento 2 repository according to the [Fork A Repository instructions](https://devdocs.magento.com/guides/v2.3/contributor-guide/contributing.html#fork) and when you are ready to send us a pull request – follow the [Create A Pull Request instructions](https://devdocs.magento.com/guides/v2.3/contributor-guide/contributing.html#pull_request).
5. Once your contribution is received the Magento 2 development team will review the contribution and collaborate with you as needed.

## Code of Conduct

Please note that this project is released with a Contributor Code of Conduct. We expect you to agree to its terms when participating in this project.
The full text is available in the repository [Wiki](https://github.com/magento/magento2/wiki/Magento-Code-of-Conduct).

## Connecting with Community!

If you have any questions, join us in [#beginners](https://magentocommeng.slack.com/messages/CH8BGFX9D) Slack chat. If you are not on our slack, [click here](http://tinyurl.com/engcom-slack) to join.

Need to find a project? Check out the [Slack Channels](https://github.com/magento/magento2/wiki/Slack-Channels) (with listed project info) and the [Magento Community Portal](https://opensource.magento.com/).
